/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CloverDatabaseSpec;
import com.atlassian.clover.ProgressListener;
import com.atlassian.clover.ant.tasks.AbstractCloverTask;
import com.atlassian.clover.cfg.Interval;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;

public class CloverMergeTask
extends AbstractCloverTask {
    private List<CloverDatabaseSpec> cloverDbs = new ArrayList<CloverDatabaseSpec>();
    private List<CloverDbSet> cloverDbSets;
    private boolean update = false;
    private Interval updateSpan = Interval.DEFAULT_SPAN;

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public void setUpdateSpan(Interval updateSpan) {
        this.updateSpan = updateSpan;
    }

    public void addCloverDb(CloverDatabaseSpec db) {
        this.cloverDbs.add(db);
    }

    public void addCloverDbSet(CloverDbSet dbset) {
        if (this.cloverDbSets == null) {
            this.cloverDbSets = new ArrayList<CloverDbSet>();
        }
        this.cloverDbSets.add(dbset);
    }

    public void cloverExecute() {
        if (this.getInitString() == null) {
            throw new BuildException("You must specify the location of the new clover database with the \"initString\" attribute");
        }
        String initString = this.resolveInitString();
        if (this.cloverDbSets != null) {
            for (CloverDbSet dbset : this.cloverDbSets) {
                this.cloverDbs.addAll(dbset.getIncludedDbs());
            }
        }
        if (this.cloverDbs.size() == 0 && !this.update) {
            throw new BuildException("You must specify one or more coverage databases to merge using a nested  <cloverdb> or <cloverdbset> element.");
        }
        try {
            CloverDatabase.merge(this.cloverDbs, initString, this.update, this.updateSpan, new ProgressListener(){

                public void handleProgress(String desc, float pc) {
                    CloverMergeTask.this.log(desc);
                }
            });
        }
        catch (Exception e) {
            throw new BuildException("Error writing new clover db at \"" + initString + "\": " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloverDbSet
    extends FileSet {
        private Interval span = Interval.DEFAULT_SPAN;

        public Interval getSpan() {
            return this.span;
        }

        public void setSpan(Interval span) {
            this.span = span;
        }

        public List<CloverDatabaseSpec> getIncludedDbs() {
            CloverDbSet fs = this.isReference() ? (FileSet)this.getCheckedRef(FileSet.class, "fileset") : this;
            String[] files = fs.getDirectoryScanner(this.getProject()).getIncludedFiles();
            LinkedList<CloverDatabaseSpec> dbs = new LinkedList<CloverDatabaseSpec>();
            String baseDir = fs.getDir(this.getProject()).getAbsolutePath();
            for (String fileName : files) {
                dbs.add(new CloverDatabaseSpec(baseDir + "/" + fileName, this.span));
            }
            return dbs;
        }
    }
}

