/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.openjdk.jmc.flightrecorder.writer.RecordingImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.api.NamedType;
import org.openjdk.jmc.flightrecorder.writer.api.RecordingSettings;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

class RecordingImplTest {
    private RecordingImpl recording;
    private ByteArrayOutputStream bos;

    RecordingImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.bos = new ByteArrayOutputStream();
        this.recording = new RecordingImpl((OutputStream)this.bos, new RecordingSettings());
    }

    @AfterEach
    void tearDown() throws Exception {
        this.recording.close();
    }

    @Test
    void registerEventTypeNullName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recording.registerEventType(null));
    }

    @Test
    void registerEventTypeNullCallback() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recording.registerEventType("name", null));
    }

    @Test
    void registerEventCallaback() {
        String name = "custom.Event";
        String fieldName = "field";
        TypeImpl eventType = this.recording.registerEventType(name, t -> t.addField(fieldName, (Types.Predefined)Types.Builtin.STRING));
        Assertions.assertNotNull((Object)eventType);
        Assertions.assertEquals((Object)name, (Object)eventType.getTypeName());
        Assertions.assertEquals((Object)"jdk.jfr.Event", (Object)eventType.getSupertype());
        Assertions.assertNotNull((Object)eventType.getField(fieldName));
        Assertions.assertFalse((boolean)eventType.hasConstantPool());
    }

    @Test
    void registerEventTypeNew() {
        String name = "custom.Event";
        TypeImpl eventType = this.recording.registerEventType(name);
        Assertions.assertNotNull((Object)eventType);
        Assertions.assertEquals((Object)name, (Object)eventType.getTypeName());
        Assertions.assertEquals((Object)"jdk.jfr.Event", (Object)eventType.getSupertype());
        Assertions.assertFalse((boolean)eventType.hasConstantPool());
    }

    @Test
    void registerEventTypeExisting() {
        String name = "custom.Event";
        TypeImpl eventType = this.recording.registerEventType(name);
        TypeImpl eventType1 = this.recording.registerEventType(name);
        Assertions.assertEquals((Object)eventType, (Object)eventType1);
    }

    @Test
    void registerAnnotationTypeNullName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recording.registerAnnotationType(null));
    }

    @Test
    void registerAnnotationTypeNullCallback() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recording.registerAnnotationType("name", null));
    }

    @Test
    void registerAnnotationTypeWithCallback() {
        String name = "custom.Annotation";
        String fieldName = "field";
        TypeImpl annotationType = this.recording.registerAnnotationType(name, t -> t.addField(fieldName, (Types.Predefined)Types.Builtin.STRING));
        Assertions.assertNotNull((Object)annotationType);
        Assertions.assertEquals((Object)name, (Object)annotationType.getTypeName());
        Assertions.assertEquals((Object)"java.lang.annotation.Annotation", (Object)annotationType.getSupertype());
        Assertions.assertEquals((int)1, (int)annotationType.getFields().size());
        Assertions.assertNotNull((Object)annotationType.getField(fieldName));
        Assertions.assertTrue((boolean)annotationType.hasConstantPool());
    }

    @Test
    void registerAnnotationTypeNew() {
        String name = "custom.Annotation";
        TypeImpl annotationType = this.recording.registerAnnotationType(name);
        Assertions.assertNotNull((Object)annotationType);
        Assertions.assertEquals((Object)name, (Object)annotationType.getTypeName());
        Assertions.assertEquals((Object)"java.lang.annotation.Annotation", (Object)annotationType.getSupertype());
        Assertions.assertTrue((boolean)annotationType.hasConstantPool());
    }

    @Test
    void registerAnnotationTypeExisting() {
        String name = "custom.Annotation";
        TypeImpl annotationType = this.recording.registerAnnotationType(name);
        TypeImpl annotationType1 = this.recording.registerAnnotationType(name);
        Assertions.assertEquals((Object)annotationType, (Object)annotationType1);
    }

    @Test
    void registerTypeNulls() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recording.registerType(null, builder -> {}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recording.registerType("name", null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recording.registerType(null, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recording.registerType(null, "super", builder -> {}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recording.registerType("name", "super", null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recording.registerType(null, "super", null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recording.registerType(null, null, builder -> {}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recording.registerType("name", null, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recording.registerType(null, null, null));
    }

    @ParameterizedTest
    @EnumSource(value=Types.JDK.class)
    void getBuiltinJDKType(Types.JDK target) {
        TypeImpl type = this.recording.getType(target);
        Assertions.assertNotNull((Object)type);
        Assertions.assertTrue((boolean)type.hasConstantPool());
    }

    @ParameterizedTest
    @EnumSource(value=Types.Builtin.class)
    void getBuiltinType(Types.Builtin target) {
        TypeImpl type = this.recording.getType(target.getTypeName());
        Assertions.assertNotNull((Object)type);
        Assertions.assertEquals((Object)target.isSame((NamedType)Types.Builtin.STRING), (Object)type.hasConstantPool());
    }

    @Test
    void getNullType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recording.getType((Types.JDK)null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recording.getType((String)null));
    }

    @Test
    void getInvalidType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recording.getType("Invalid type"));
    }

    @Test
    void getRegisteredType() {
        String typeName = "custom.Type";
        TypeImpl type = this.recording.registerType(typeName, builder -> {});
        TypeImpl type1 = this.recording.getType(typeName);
        Assertions.assertNotNull((Object)type1);
        Assertions.assertEquals((Object)type, (Object)type1);
    }
}

