/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.CompoundArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;
import org.eclipse.tycho.zipcomparator.internal.SimpleArtifactDelta;

@Component(role=ContentsComparator.class, hint="manifest")
public class ManifestComparator
implements ContentsComparator {
    public static final String TYPE = "manifest";
    private static final Collection<Attributes.Name> IGNORED_KEYS;

    @Override
    public ArtifactDelta getDelta(InputStream baseline, InputStream reactor, MojoExecution mojo) throws IOException {
        TreeMap<String, ArtifactDelta> result = new TreeMap<String, ArtifactDelta>();
        Manifest manifest = new Manifest(baseline);
        Manifest manifest2 = new Manifest(reactor);
        Attributes attributes = manifest.getMainAttributes();
        Attributes attributes2 = manifest2.getMainAttributes();
        LinkedHashSet<Attributes.Name> names = new LinkedHashSet<Attributes.Name>();
        names.addAll(this.getNames(attributes));
        names.addAll(this.getNames(attributes2));
        for (Attributes.Name key : names) {
            String value = attributes.getValue(key);
            if (value == null) {
                this.addDelta(result, key, "not present in baseline version");
                continue;
            }
            String value2 = attributes2.getValue(key);
            if (value2 == null) {
                this.addDelta(result, key, "present in baseline version only");
                continue;
            }
            if (value.equals(value2)) continue;
            this.addDelta(result, key, "baseline='" + value + "' != reactor='" + value2 + "'");
        }
        return !result.isEmpty() ? new CompoundArtifactDelta("different", result) : null;
    }

    protected void addDelta(TreeMap<String, ArtifactDelta> result, Attributes.Name key, String message) {
        result.put(key.toString(), new SimpleArtifactDelta(message));
    }

    protected Set<Attributes.Name> getNames(Attributes attributes) {
        LinkedHashSet<Attributes.Name> result = new LinkedHashSet<Attributes.Name>();
        for (Object key : attributes.keySet()) {
            Attributes.Name name = (Attributes.Name)key;
            if (IGNORED_KEYS.contains(name)) continue;
            result.add(name);
        }
        return result;
    }

    static {
        ArrayList<Attributes.Name> ignoredKeys = new ArrayList<Attributes.Name>();
        ignoredKeys.add(new Attributes.Name("Archiver-Version"));
        ignoredKeys.add(new Attributes.Name("Created-By"));
        ignoredKeys.add(new Attributes.Name("Build-Jdk"));
        ignoredKeys.add(new Attributes.Name("Built-By"));
        ignoredKeys.add(new Attributes.Name("Build-Jdk-Spec"));
        ignoredKeys.add(new Attributes.Name("Bnd-LastModified"));
        ignoredKeys.add(new Attributes.Name("Tool"));
        ignoredKeys.add(new Attributes.Name("Eclipse-SourceReferences"));
        IGNORED_KEYS = Collections.unmodifiableCollection(ignoredKeys);
    }
}

