/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test.rules.jdk;

import org.openjdk.jmc.common.item.IAccessorKey;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.MemberAccessorToolkit;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.TestEvent;

public class FileTestEvent
extends TestEvent {
    private final String fileName;
    private final long duration;
    private final long bytesProcessed;

    public FileTestEvent(String eventType, String fileName, long duration, long bytesProcessed) {
        super(eventType);
        this.fileName = fileName;
        this.duration = duration;
        this.bytesProcessed = bytesProcessed;
    }

    @Override
    public <M> IMemberAccessor<M, IItem> getAccessor(IAccessorKey<M> attribute) {
        if ("duration".equals(attribute.getIdentifier())) {
            return MemberAccessorToolkit.constant((Object)UnitLookup.MILLISECOND.quantity(this.duration));
        }
        if ("path".equals(attribute.getIdentifier())) {
            return MemberAccessorToolkit.constant((Object)this.fileName);
        }
        if ("bytesRead".equals(attribute.getIdentifier())) {
            return MemberAccessorToolkit.constant((Object)UnitLookup.BYTE.quantity(this.bytesProcessed));
        }
        if ("bytesWritten".equals(attribute.getIdentifier())) {
            return MemberAccessorToolkit.constant((Object)UnitLookup.BYTE.quantity(this.bytesProcessed));
        }
        return null;
    }
}

