/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test.rules.dataproviders;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders.JvmInternalsDataProvider;

public class TestJvmInternalsDataProvider {
    @Test
    public void testJavaAgentDuplicateFlags() {
        Assert.assertEquals((String)"same jar, no option", (long)1L, (long)JvmInternalsDataProvider.checkDuplicates((String)"-javaagent:myjar.jar -javaagent:myjar.jar").toArray().length);
        Assert.assertEquals((String)"different jar, no option", (long)0L, (long)JvmInternalsDataProvider.checkDuplicates((String)"-javaagent:myjar.jar -javaagent:anotherjar.jar").toArray().length);
        Assert.assertEquals((String)"same jar, same option", (long)1L, (long)JvmInternalsDataProvider.checkDuplicates((String)"-javaagent:myjar.jar=option -javaagent:myjar.jar=option").toArray().length);
        Assert.assertEquals((String)"different jar, same option", (long)0L, (long)JvmInternalsDataProvider.checkDuplicates((String)"-javaagent:myjar.jar=option -javaagent:anotherjar.jar=option").toArray().length);
        Assert.assertEquals((String)"same jar, different option", (long)1L, (long)JvmInternalsDataProvider.checkDuplicates((String)"-javaagent:myjar.jar=option -javaagent:myjar.jar=anotheroption").toArray().length);
        Assert.assertEquals((String)"different jar, different option", (long)0L, (long)JvmInternalsDataProvider.checkDuplicates((String)"-javaagent:myjar.jar=option -javaagent:anotherjar.jar=anotheroption").toArray().length);
    }

    @Test
    public void testJavaAgentPathIsParsedCorrectly() {
        String arguments = "-javagent:c:/path/to/archive/myjar.jar -javagent:c:/path/to/archive/myjar.jar";
        String expectedResult = "-javagent:c:/path/to/archive/myjar.jar";
        Collection result = JvmInternalsDataProvider.checkDuplicates((String)arguments);
        String actualResult = (String)((ArrayList)result.toArray()[0]).get(0);
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }
}

