/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.impl.publisher.MavenPropertiesAdvice;
import org.eclipse.tycho.p2.impl.publisher.repo.TransientArtifactRepository;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.repository.MavenRepositoryCoordinates;
import org.eclipse.tycho.p2.resolver.WrappedArtifact;
import org.eclipse.tycho.p2.target.MavenBundleInfo;
import org.eclipse.tycho.p2.target.repository.MavenBundlesArtifactRepository;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactFileProvider;
import org.eclipse.tycho.repository.util.StatusTool;
import org.osgi.framework.BundleException;

public class TargetPlatformBundlePublisher {
    private final MavenLogger logger;
    private final MavenBundlesArtifactRepository publishedArtifacts;
    private ReactorProject project;

    public TargetPlatformBundlePublisher(File localMavenRepositoryRoot, ReactorProject project, MavenLogger logger) {
        this.project = project;
        this.publishedArtifacts = new MavenBundlesArtifactRepository(localMavenRepositoryRoot);
        this.logger = logger;
    }

    MavenBundleInfo attemptToPublishBundle(IArtifactFacade mavenArtifact, boolean wrapIfNessesary) {
        MavenBundleInfo publishedIU;
        if (!this.isAvailableAsLocalFile(mavenArtifact)) {
            throw new IllegalArgumentException("Not an artifact file: " + mavenArtifact.getLocation());
        }
        PublisherRun publisherRun = new PublisherRun(mavenArtifact, this.project, this.publishedArtifacts.getBaseDir(), this.logger, wrapIfNessesary);
        IStatus status = publisherRun.execute();
        if (!status.isOK()) {
            this.logger.warn(StatusTool.collectProblems((IStatus)status), status.getException());
        }
        if ((publishedIU = publisherRun.getPublishedUnitIfExists()) != null) {
            this.publishedArtifacts.addPublishedArtifact(publishedIU.getDescriptor(), publishedIU.getArtifact());
        }
        return publishedIU;
    }

    private boolean isAvailableAsLocalFile(IArtifactFacade artifact) {
        File localLocation = artifact.getLocation();
        return localLocation != null && localLocation.isFile();
    }

    IRawArtifactFileProvider getArtifactRepoOfPublishedBundles() {
        return this.publishedArtifacts;
    }

    private static class PublisherRun {
        private static final String EXCEPTION_CONTEXT = "Error while adding Maven artifact to the target platform: ";
        private final IArtifactFacade mavenArtifact;
        private PublisherInfo publisherInfo;
        private TransientArtifactRepository collectedDescriptors;
        private PublisherResult publisherResult;
        private IArtifactFacade publishedArtifact;
        private ReactorProject project;
        private File basedir;
        private MavenLogger logger;
        private boolean wrapIfNessesary;

        PublisherRun(IArtifactFacade artifact, ReactorProject project, File basedir, MavenLogger logger, boolean wrapIfNessesary) {
            this.mavenArtifact = artifact;
            this.project = project;
            this.basedir = basedir;
            this.logger = logger;
            this.wrapIfNessesary = wrapIfNessesary;
        }

        IStatus execute() {
            block9: {
                try {
                    BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)this.mavenArtifact.getLocation());
                    if (bundleDescription == null) {
                        return new Status(0, TargetPlatformBundlePublisher.class.getName(), "artifact file " + this.mavenArtifact.getLocation() + " is certainly not a bundle/jar file");
                    }
                    if (bundleDescription.getSymbolicName() == null) {
                        if (this.wrapIfNessesary) {
                            try {
                                MavenRepositoryCoordinates repositoryCoordinates = new MavenRepositoryCoordinates(this.mavenArtifact.getGroupId(), this.mavenArtifact.getArtifactId(), this.mavenArtifact.getVersion(), WrappedArtifact.createClassifierFromArtifact(this.mavenArtifact), null);
                                File wrappedFile = new File(this.basedir, repositoryCoordinates.getLocalRepositoryPath());
                                WrappedArtifact wrappedArtifact = WrappedArtifact.createWrappedArtifact(this.mavenArtifact, this.project.getGroupId(), wrappedFile);
                                this.publishedArtifact = wrappedArtifact;
                                this.logger.warn("Maven Artifact " + this.mavenArtifact.getGroupId() + ":" + this.mavenArtifact.getArtifactId() + ":" + this.mavenArtifact.getVersion() + " is not a bundle and was automatically wrapped with bundle-symbolic name " + wrappedArtifact.getWrappedBsn() + ", ignoring such artifacts can be enabled with <pomDependencies>consider</pomDependencies> in target platform configuration.");
                                this.logger.info(wrappedArtifact.getReferenceHint());
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("The follwoing manifest was generated for this artifact:\r\n" + wrappedArtifact.getGeneratedManifest());
                                }
                                break block9;
                            }
                            catch (Exception e) {
                                return new Status(4, TargetPlatformBundlePublisher.class.getName(), "wrapping file " + this.mavenArtifact.getLocation() + " failed", (Throwable)e);
                            }
                        }
                        this.logger.info("Maven Artifact " + this.mavenArtifact.getGroupId() + ":" + this.mavenArtifact.getArtifactId() + ":" + this.mavenArtifact.getVersion() + " is not a bundle and will be ignored, automatic wrapping of such artifacts can be enabled with " + "<pomDependencies>wrapAsBundle</pomDependencies> in target platform configuration.");
                        return new Status(0, TargetPlatformBundlePublisher.class.getName(), "Nothing to do");
                    }
                    this.publishedArtifact = this.mavenArtifact;
                }
                catch (IOException e) {
                    return new Status(2, TargetPlatformBundlePublisher.class.getName(), "reading file " + this.mavenArtifact.getLocation() + " failed", (Throwable)e);
                }
                catch (BundleException e) {
                    return new Status(2, TargetPlatformBundlePublisher.class.getName(), "reading maven manifest from file: " + this.mavenArtifact.getLocation() + " failed", (Throwable)e);
                }
            }
            this.publisherInfo = new PublisherInfo();
            this.enableArtifactDescriptorCollection();
            this.enableUnitAnnotationWithGAV();
            BundlesAction bundlesAction = new BundlesAction(new File[]{this.publishedArtifact.getLocation()});
            IStatus status = this.executePublisherAction(bundlesAction);
            return status;
        }

        private void enableArtifactDescriptorCollection() {
            this.publisherInfo.setArtifactOptions(1);
            this.collectedDescriptors = new TransientArtifactRepository();
            this.publisherInfo.setArtifactRepository((IArtifactRepository)this.collectedDescriptors);
        }

        private void enableUnitAnnotationWithGAV() {
            MavenPropertiesAdvice advice = new MavenPropertiesAdvice(this.publishedArtifact.getGroupId(), this.publishedArtifact.getArtifactId(), this.publishedArtifact.getVersion(), this.publishedArtifact.getClassifier());
            this.publisherInfo.addAdvice((IPublisherAdvice)advice);
        }

        private IStatus executePublisherAction(BundlesAction action) {
            IPublisherAction[] actions = new IPublisherAction[]{action};
            this.publisherResult = new PublisherResult();
            return new Publisher((IPublisherInfo)this.publisherInfo, (IPublisherResult)this.publisherResult).publish(actions, null);
        }

        MavenBundleInfo getPublishedUnitIfExists() {
            if (this.publisherResult == null) {
                return null;
            }
            Collection units = this.publisherResult.getIUs(null, null);
            if (units.isEmpty()) {
                return null;
            }
            if (units.size() == 1) {
                IInstallableUnit unit = (IInstallableUnit)units.iterator().next();
                IArtifactDescriptor artifactDescriptor = this.getPublishedArtifactDescriptor();
                return new MavenBundleInfo(unit, artifactDescriptor, this.publishedArtifact);
            }
            throw new AssertionFailedException("Error while adding Maven artifact to the target platform: BundlesAction produced more than one IU for " + this.mavenArtifact.getLocation());
        }

        IArtifactDescriptor getPublishedArtifactDescriptor() {
            Set<IArtifactDescriptor> descriptors = this.collectedDescriptors.getArtifactDescriptors();
            if (descriptors.isEmpty()) {
                throw new AssertionFailedException("Error while adding Maven artifact to the target platform: BundlesAction did not create an artifact entry for " + this.mavenArtifact.getLocation());
            }
            if (descriptors.size() == 1) {
                return descriptors.iterator().next();
            }
            throw new AssertionFailedException("Error while adding Maven artifact to the target platform: BundlesAction created more than one artifact entry for " + this.mavenArtifact.getLocation());
        }
    }
}

