/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.remote.RemoteRepositoryCacheManager;

class OfflineTransport
extends Transport {
    private File cacheLocation;
    private MavenLogger logger;

    public OfflineTransport(MavenContext mavenContext) {
        this.cacheLocation = new File(mavenContext.getLocalRepositoryRoot(), ".cache/tycho/p2-repository-metadata");
        this.logger = mavenContext.getLogger();
    }

    public IStatus download(URI toDownload, OutputStream target, IProgressMonitor monitor) {
        return this.download(toDownload, target, 0L, monitor);
    }

    public IStatus download(URI source, OutputStream target, long startPos, IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (InputStream in = this.stream(source, monitor);){
                long s = 0L;
                while (s < startPos) {
                    in.read();
                    ++s;
                }
                in.transferTo(target);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.tycho.p2.impl", String.format("loading %s from cache at position %d failed", source, startPos), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public InputStream stream(URI source, IProgressMonitor monitor) throws FileNotFoundException {
        File cacheFile = RemoteRepositoryCacheManager.getCacheFile(source, this.cacheLocation);
        if (cacheFile != null && cacheFile.exists()) {
            this.logger.debug(String.format("return cached file %s for uri %s, maven is currently in offline mode", cacheFile, source));
            return new FileInputStream(cacheFile);
        }
        throw new FileNotFoundException(String.format("maven is currently in offline mode but cachefile %s for requested URI %s does not exist locally!", cacheFile, source));
    }

    public long getLastModified(URI toDownload, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException {
        File cacheFile = RemoteRepositoryCacheManager.getCacheFile(toDownload, this.cacheLocation);
        if (cacheFile != null && cacheFile.exists()) {
            return cacheFile.lastModified();
        }
        return -1L;
    }
}

