/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestTag;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.tagexpression.TagExpression;

@API(status=API.Status.STABLE, since="1.0")
public final class TagFilter {
    private TagFilter() {
    }

    public static PostDiscoveryFilter includeTags(String ... tagExpressions) throws PreconditionViolationException {
        Preconditions.notNull(tagExpressions, "array of tag expressions must not be null");
        return TagFilter.includeTags(Arrays.asList(tagExpressions));
    }

    public static PostDiscoveryFilter includeTags(List<String> tagExpressions) throws PreconditionViolationException {
        return TagFilter.includeMatching(tagExpressions, Stream::anyMatch);
    }

    public static PostDiscoveryFilter excludeTags(String ... tagExpressions) throws PreconditionViolationException {
        Preconditions.notNull(tagExpressions, "array of tag expressions must not be null");
        return TagFilter.excludeTags(Arrays.asList(tagExpressions));
    }

    public static PostDiscoveryFilter excludeTags(List<String> tagExpressions) throws PreconditionViolationException {
        return TagFilter.includeMatching(tagExpressions, Stream::noneMatch);
    }

    private static PostDiscoveryFilter includeMatching(List<String> tagExpressions, BiPredicate<Stream<TagExpression>, Predicate<TagExpression>> matcher) {
        Preconditions.notEmpty(tagExpressions, "list of tag expressions must not be null or empty");
        List<TagExpression> parsedTagExpressions = TagFilter.parseAll(tagExpressions);
        return descriptor -> {
            Set<TestTag> tags = descriptor.getTags();
            return FilterResult.includedIf(matcher.test(parsedTagExpressions.stream(), expression -> expression.evaluate(tags)));
        };
    }

    private static List<TagExpression> parseAll(List<String> tagExpressions) {
        return tagExpressions.stream().map(TagFilter::parse).collect(CollectionUtils.toUnmodifiableList());
    }

    private static TagExpression parse(String tagExpression) {
        return TagExpression.parseFrom(tagExpression).tagExpressionOrThrow(message -> new PreconditionViolationException("Unable to parse tag expression \"" + tagExpression + "\": " + message));
    }
}

