/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.local.index;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.locking.facade.FileLockService;
import org.eclipse.tycho.locking.facade.FileLocker;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;

public class FileBasedTychoRepositoryIndex
implements TychoRepositoryIndex {
    public static final String ARTIFACTS_INDEX_RELPATH = ".meta/p2-artifacts.properties";
    public static final String METADATA_INDEX_RELPATH = ".meta/p2-local-metadata.properties";
    private static final String EOL = "\n";
    private final File indexFile;
    private final MavenLogger logger;
    private FileLocker fileLocker;
    private Set<GAV> addedGavs = new HashSet<GAV>();
    private Set<GAV> removedGavs = new HashSet<GAV>();
    private Set<GAV> gavs = new HashSet<GAV>();

    private FileBasedTychoRepositoryIndex(File indexFile, FileLockService fileLockService, MavenLogger logger) {
        this.indexFile = indexFile;
        this.fileLocker = fileLockService.getFileLocker(indexFile);
        this.logger = logger;
        if (indexFile.isFile()) {
            this.lock();
            try {
                try {
                    this.gavs = this.read(new FileInputStream(indexFile));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    private void lock() {
        this.fileLocker.lock();
    }

    private void unlock() {
        this.fileLocker.release();
    }

    public synchronized Set<GAV> getProjectGAVs() {
        return Collections.unmodifiableSet(new LinkedHashSet<GAV>(this.gavs));
    }

    public synchronized void addGav(GAV gav) {
        this.gavs.add(gav);
        this.addedGavs.add(gav);
        if (this.removedGavs.contains(gav)) {
            this.removedGavs.remove(gav);
        }
    }

    public synchronized void removeGav(GAV gav) {
        this.gavs.remove(gav);
        this.removedGavs.add(gav);
        if (this.addedGavs.contains(gav)) {
            this.addedGavs.remove(gav);
        }
    }

    public void save() throws IOException {
        File parentDir = this.indexFile.getParentFile();
        if (!parentDir.isDirectory()) {
            parentDir.mkdirs();
        }
        this.lock();
        try {
            this.reconcile();
            File tempFile = File.createTempFile("index", "tmp", this.indexFile.getParentFile());
            this.write(new FileOutputStream(tempFile));
            if (this.indexFile.isFile()) {
                this.indexFile.delete();
            }
            tempFile.renameTo(this.indexFile);
        }
        finally {
            this.unlock();
        }
    }

    private synchronized void reconcile() throws IOException {
        if (this.indexFile.isFile()) {
            this.gavs = this.read(new FileInputStream(this.indexFile));
            for (GAV addedGav : this.addedGavs) {
                this.addGav(addedGav);
            }
            for (GAV removedGav : this.removedGavs) {
                this.removeGav(removedGav);
            }
        }
        this.addedGavs.clear();
        this.removedGavs.clear();
    }

    private void write(OutputStream outStream) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outStream), StandardCharsets.UTF_8);){
            for (GAV gav : this.getProjectGAVs()) {
                out.write(gav.toExternalForm());
                out.write(EOL);
            }
            ((Writer)out).flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<GAV> read(InputStream inStream) throws IOException {
        LinkedHashSet<GAV> result = new LinkedHashSet<GAV>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    return result;
                }
                if (line.trim().isEmpty()) continue;
                try {
                    GAV parsedGAV = GAV.parse((String)line);
                    result.add(parsedGAV);
                }
                catch (IllegalArgumentException e) {
                    this.logger.warn("Ignoring invalid line '" + line + "' in " + this.indexFile);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public static TychoRepositoryIndex createMetadataIndex(File basedir, FileLockService fileLockService, MavenLogger logger) {
        return new FileBasedTychoRepositoryIndex(new File(basedir, METADATA_INDEX_RELPATH), fileLockService, logger);
    }

    public static TychoRepositoryIndex createArtifactsIndex(File basedir, FileLockService fileLockService, MavenLogger logger) {
        return new FileBasedTychoRepositoryIndex(new File(basedir, ARTIFACTS_INDEX_RELPATH), fileLockService, logger);
    }
}

