/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.test.unit;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openjdk.jmc.common.test.MCTestCase;
import org.openjdk.jmc.common.unit.BinaryPrefix;
import org.openjdk.jmc.common.unit.DecimalPrefix;
import org.openjdk.jmc.common.unit.IPrefix;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.UnitLookup;

public class DeriveUnitTest
extends MCTestCase {
    private LinearUnit one;
    private LinearUnit B;
    private LinearUnit kiB;
    private LinearUnit MiB;
    private LinearUnit ms;
    private LinearUnit s;
    private LinearUnit min;
    private LinearUnit h;
    private LinearUnit d;
    private LinearUnit wk;
    private LinearUnit y;
    private LinearUnit Hz;
    private LinearUnit kHz;
    private LinearUnit MHz;
    private LinearUnit mHz;
    private LinearUnit uHz;

    @Before
    public void setUp() throws Exception {
        this.one = UnitLookup.NUMBER_UNITY;
        this.B = UnitLookup.BYTE;
        this.kiB = UnitLookup.MEMORY.getUnit((IPrefix)BinaryPrefix.KIBI);
        this.MiB = UnitLookup.MEMORY.getUnit((IPrefix)BinaryPrefix.MEBI);
        LinearKindOfQuantity span = UnitLookup.TIMESPAN;
        this.ms = UnitLookup.MILLISECOND;
        this.s = UnitLookup.SECOND;
        this.min = UnitLookup.MINUTE;
        this.h = span.getUnit("h");
        this.d = span.getUnit("d");
        this.wk = span.getUnit("wk");
        this.y = span.getUnit("a");
        this.Hz = UnitLookup.HERTZ;
        LinearKindOfQuantity freq = UnitLookup.FREQUENCY;
        this.kHz = freq.getUnit((IPrefix)DecimalPrefix.KILO);
        this.MHz = freq.getUnit((IPrefix)DecimalPrefix.MEGA);
        this.mHz = freq.getUnit((IPrefix)DecimalPrefix.MILLI);
        this.uHz = freq.getUnit((IPrefix)DecimalPrefix.MICRO);
    }

    private void assertDerivedUnit(IUnit expectedUnit, IQuantity quantity) throws Exception {
        KindOfQuantity kind = quantity.getType();
        Assert.assertEquals((Object)expectedUnit, (Object)kind.getLargestExactUnit(quantity));
    }

    @Test
    public void testMemoryUnits() throws Exception {
        this.assertDerivedUnit((IUnit)this.kiB, (IQuantity)this.B.quantity(2048L));
        this.assertDerivedUnit((IUnit)this.kiB, (IQuantity)this.B.quantity(1024L));
        this.assertDerivedUnit((IUnit)this.B, (IQuantity)this.B.quantity(512L));
        this.assertDerivedUnit((IUnit)this.B, (IQuantity)this.B.quantity(2050L));
        this.assertDerivedUnit((IUnit)this.B, (IQuantity)this.B.quantity(1L));
        this.assertDerivedUnit((IUnit)this.B, (IQuantity)this.kiB.quantity(0.5));
        this.assertDerivedUnit((IUnit)this.MiB, (IQuantity)this.kiB.quantity(2048L));
        this.assertDerivedUnit((IUnit)this.MiB, (IQuantity)this.kiB.quantity(1024L));
        this.assertDerivedUnit((IUnit)this.kiB, (IQuantity)this.kiB.quantity(512L));
        this.assertDerivedUnit((IUnit)this.kiB, (IQuantity)this.kiB.quantity(2050L));
        this.assertDerivedUnit((IUnit)this.kiB, (IQuantity)this.kiB.quantity(1L));
        this.assertDerivedUnit((IUnit)this.kiB, (IQuantity)this.MiB.quantity(0.5));
        this.assertDerivedUnit((IUnit)this.MiB, (IQuantity)this.MiB.quantity(1L));
        this.assertDerivedUnit(null, (IQuantity)this.B.quantity(0.5));
        this.assertDerivedUnit(null, (IQuantity)this.B.quantity(0.1));
    }

    @Test
    public void testFrequencies() throws Exception {
        this.assertDerivedUnit((IUnit)this.Hz, (IQuantity)this.Hz.quantity(1L));
        this.assertDerivedUnit((IUnit)this.Hz, (IQuantity)this.Hz.quantity(999L));
        this.assertDerivedUnit((IUnit)this.kHz, (IQuantity)this.Hz.quantity(1000L));
        this.assertDerivedUnit((IUnit)this.kHz, (IQuantity)this.kHz.quantity(999L));
        this.assertDerivedUnit((IUnit)this.MHz, (IQuantity)this.kHz.quantity(1000L));
        this.assertDerivedUnit((IUnit)this.mHz, (IQuantity)this.Hz.quantity(0.5));
        this.assertDerivedUnit((IUnit)this.uHz, (IQuantity)this.mHz.quantity(0.5));
    }

    @Test
    public void testNumbers() throws Exception {
        this.assertDerivedUnit((IUnit)this.one, (IQuantity)this.one.quantity(2001L));
        this.assertDerivedUnit((IUnit)this.one, (IQuantity)this.one.quantity(1000L));
        this.assertDerivedUnit((IUnit)this.one, (IQuantity)this.one.quantity(2000L));
        this.assertDerivedUnit((IUnit)this.one, (IQuantity)this.one.quantity(1000000L));
        this.assertDerivedUnit((IUnit)this.one, (IQuantity)this.one.quantity(2000000L));
        this.assertDerivedUnit((IUnit)this.one, (IQuantity)this.one.quantity(1L));
        this.assertDerivedUnit(null, (IQuantity)this.one.quantity(0.5));
        this.assertDerivedUnit(null, (IQuantity)this.one.quantity(0.1));
    }

    @Test
    public void testSeconds() throws Exception {
        this.assertDerivedUnit((IUnit)this.min, (IQuantity)this.s.quantity(120L));
        this.assertDerivedUnit((IUnit)this.min, (IQuantity)this.s.quantity(60L));
        this.assertDerivedUnit((IUnit)this.s, (IQuantity)this.s.quantity(125L));
        this.assertDerivedUnit((IUnit)this.s, (IQuantity)this.s.quantity(1L));
        this.assertDerivedUnit((IUnit)this.s, (IQuantity)this.s.quantity(1.0));
        this.assertDerivedUnit((IUnit)this.ms, (IQuantity)this.s.quantity(0.5));
    }

    @Test
    public void testMinutes() throws Exception {
        this.assertDerivedUnit((IUnit)this.h, (IQuantity)this.min.quantity(120L));
        this.assertDerivedUnit((IUnit)this.h, (IQuantity)this.min.quantity(60L));
        this.assertDerivedUnit((IUnit)this.min, (IQuantity)this.min.quantity(125L));
        this.assertDerivedUnit((IUnit)this.min, (IQuantity)this.min.quantity(1L));
        this.assertDerivedUnit((IUnit)this.min, (IQuantity)this.min.quantity(1.0));
        this.assertDerivedUnit((IUnit)this.s, (IQuantity)this.min.quantity(0.5));
    }

    @Test
    public void testHours() throws Exception {
        this.assertDerivedUnit((IUnit)this.d, (IQuantity)this.h.quantity(48L));
        this.assertDerivedUnit((IUnit)this.d, (IQuantity)this.h.quantity(24L));
        this.assertDerivedUnit((IUnit)this.h, (IQuantity)this.h.quantity(50L));
        this.assertDerivedUnit((IUnit)this.h, (IQuantity)this.h.quantity(1L));
        this.assertDerivedUnit((IUnit)this.h, (IQuantity)this.h.quantity(1.0));
        this.assertDerivedUnit((IUnit)this.min, (IQuantity)this.h.quantity(0.5));
    }

    @Test
    public void testDays() throws Exception {
        this.assertDerivedUnit((IUnit)this.wk, (IQuantity)this.d.quantity(49L));
        this.assertDerivedUnit((IUnit)this.d, (IQuantity)this.d.quantity(24L));
        this.assertDerivedUnit((IUnit)this.d, (IQuantity)this.d.quantity(50L));
        this.assertDerivedUnit((IUnit)this.d, (IQuantity)this.d.quantity(1L));
        this.assertDerivedUnit((IUnit)this.d, (IQuantity)this.d.quantity(1.0));
        this.assertDerivedUnit((IUnit)this.h, (IQuantity)this.d.quantity(0.5));
    }

    @Test
    public void testWeeks() throws Exception {
        this.assertDerivedUnit((IUnit)this.wk, (IQuantity)this.wk.quantity(52L));
        this.assertDerivedUnit((IUnit)this.wk, (IQuantity)this.wk.quantity(24L));
        this.assertDerivedUnit((IUnit)this.wk, (IQuantity)this.wk.quantity(50L));
        this.assertDerivedUnit((IUnit)this.wk, (IQuantity)this.wk.quantity(1L));
        this.assertDerivedUnit((IUnit)this.wk, (IQuantity)this.wk.quantity(1.0));
        this.assertDerivedUnit((IUnit)this.h, (IQuantity)this.wk.quantity(0.5));
    }

    @Test
    public void testYears() throws Exception {
        this.assertDerivedUnit((IUnit)this.y, (IQuantity)this.y.quantity(52L));
        this.assertDerivedUnit((IUnit)this.y, (IQuantity)this.y.quantity(24L));
        this.assertDerivedUnit((IUnit)this.y, (IQuantity)this.y.quantity(50L));
        this.assertDerivedUnit((IUnit)this.y, (IQuantity)this.y.quantity(1L));
        this.assertDerivedUnit((IUnit)this.y, (IQuantity)this.y.quantity(1.0));
        this.assertDerivedUnit((IUnit)this.h, (IQuantity)this.y.quantity(0.5));
        this.assertDerivedUnit((IUnit)this.min, (IQuantity)this.y.quantity(0.25));
        this.assertDerivedUnit((IUnit)this.min, (IQuantity)this.y.quantity(0.1));
    }
}

