/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.ee.shared;

import java.util.Collection;
import java.util.Objects;
import java.util.Properties;

public interface ExecutionEnvironment {
    public String getProfileName();

    public Collection<SystemPackageEntry> getSystemPackages();

    public Properties getProfileProperties();

    public String getCompilerSourceLevelDefault();

    public String getCompilerTargetLevelDefault();

    public boolean isCompatibleCompilerTargetLevel(String var1);

    public static final class SystemPackageEntry {
        public final String packageName;
        public final String version;

        public SystemPackageEntry(String packageName, String version) {
            this.packageName = packageName;
            this.version = version;
        }

        public String toPackageSpecifier() {
            if (this.version != null) {
                return String.valueOf(this.packageName) + ";version=\"" + this.version + "\"";
            }
            return this.packageName;
        }

        public int hashCode() {
            return Objects.hash(this.packageName, this.version);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof SystemPackageEntry)) {
                return false;
            }
            SystemPackageEntry other = (SystemPackageEntry)o;
            return Objects.equals(this.packageName, other.packageName) && Objects.equals(this.version, other.version);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + '[' + this.packageName + '/' + this.version + ']';
        }
    }
}

