/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.MetadataImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueBuilderImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.TypedFieldBuilder;
import org.openjdk.jmc.flightrecorder.writer.api.TypedFieldValue;
import org.openjdk.jmc.flightrecorder.writer.api.TypedValue;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

class TypedValueBuilderImplTest {
    private static final String CUSTOM_FIELD_NAME = "custom_field";
    private static final String CUSTOM_FIELD_ARRAY_NAME = "custom_field_arr";
    private static final String SIMPLE_FIELD_VALUE = "hello";
    private static final String SIMPLE_FIELD_NAME = "field";
    private static Map<Types.Builtin, String> typeToFieldMap;
    private TypedValueBuilderImpl instance;
    private TypeImpl simpleType;
    private TypeImpl customType;
    private TypeImpl longType;

    TypedValueBuilderImplTest() {
    }

    @BeforeAll
    static void init() {
        typeToFieldMap = new HashMap<Types.Builtin, String>(Types.Builtin.values().length);
        for (Types.Builtin builtin : Types.Builtin.values()) {
            typeToFieldMap.put(builtin, builtin.name().toLowerCase() + "_field");
        }
    }

    @BeforeEach
    void setUp() {
        TypesImpl types = new TypesImpl(new MetadataImpl(new ConstantPools()));
        this.longType = types.getType((Types.Predefined)Types.Builtin.LONG);
        this.simpleType = types.getOrAdd("custom.Simple", builder -> builder.addField(SIMPLE_FIELD_NAME, (Types.Predefined)Types.Builtin.STRING));
        this.customType = types.getOrAdd("custom.Type", builder -> {
            for (Types.Builtin builtin : Types.Builtin.values()) {
                builder = builder.addField(TypedValueBuilderImplTest.getFieldName(builtin), (Types.Predefined)builtin).addField(TypedValueBuilderImplTest.getArrayFieldName(builtin), (Types.Predefined)builtin, TypedFieldBuilder::asArray);
            }
            builder.addField(CUSTOM_FIELD_NAME, (Type)this.simpleType).addField(CUSTOM_FIELD_ARRAY_NAME, (Type)this.simpleType, TypedFieldBuilder::asArray);
        });
        this.instance = new TypedValueBuilderImpl(this.customType);
    }

    @ParameterizedTest
    @EnumSource(value=Types.Builtin.class)
    void putFieldBuiltin(Types.Builtin target) {
        for (Types.Builtin type : Types.Builtin.values()) {
            if (type == target) {
                this.assertCorrectFieldValueBuiltinType(target, type, 1, false);
                continue;
            }
            this.assertWrongFieldValueBuiltinType(target, type, 0);
        }
    }

    @ParameterizedTest
    @EnumSource(value=Types.Builtin.class)
    void putFieldBuiltinArray(Types.Builtin target) {
        for (Types.Builtin type : Types.Builtin.values()) {
            if (type == target) {
                this.assertCorrectFieldValueBuiltinType(target, type, 1, true);
                continue;
            }
            this.assertWrongFieldValueBuiltinType(target, type, 0);
        }
    }

    @ParameterizedTest
    @EnumSource(value=Types.Builtin.class)
    void putFieldBuiltinArrayNonExistent(Types.Builtin target) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testPutBuiltinFieldArray(target, "not a field name", 1));
    }

    @Test
    void putFieldCustom() {
        this.instance.putField(CUSTOM_FIELD_NAME, SIMPLE_FIELD_VALUE);
        TypedFieldValueImpl fieldValue = (TypedFieldValueImpl)this.instance.build().get(CUSTOM_FIELD_NAME);
        Assertions.assertNotNull((Object)fieldValue);
        Assertions.assertEquals((Object)CUSTOM_FIELD_NAME, (Object)fieldValue.getField().getName());
        Assertions.assertEquals((Object)SIMPLE_FIELD_VALUE, (Object)fieldValue.getValue().getValue());
    }

    @Test
    void putFieldCustomBuilder() {
        this.instance.putField(CUSTOM_FIELD_NAME, v -> v.putField(SIMPLE_FIELD_NAME, SIMPLE_FIELD_VALUE));
        TypedFieldValueImpl fieldValue = (TypedFieldValueImpl)this.instance.build().get(CUSTOM_FIELD_NAME);
        Assertions.assertNotNull((Object)fieldValue);
        Assertions.assertEquals((Object)CUSTOM_FIELD_NAME, (Object)fieldValue.getField().getName());
        Assertions.assertEquals((Object)SIMPLE_FIELD_VALUE, (Object)fieldValue.getValue().getValue());
    }

    @Test
    void putFieldCustomArray() {
        this.instance.putField(CUSTOM_FIELD_ARRAY_NAME, new TypedValue[]{this.simpleType.asValue(v -> v.putField(SIMPLE_FIELD_NAME, "value1")), this.simpleType.asValue(v -> v.putField(SIMPLE_FIELD_NAME, "value2"))});
        TypedFieldValueImpl fieldValue = (TypedFieldValueImpl)this.instance.build().get(CUSTOM_FIELD_ARRAY_NAME);
        Assertions.assertNotNull((Object)fieldValue);
        Assertions.assertEquals((Object)CUSTOM_FIELD_ARRAY_NAME, (Object)fieldValue.getField().getName());
    }

    @Test
    void putFieldCustomArrayNonArrayField() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.instance.putField(CUSTOM_FIELD_NAME, new TypedValue[]{this.simpleType.asValue(v -> v.putField(SIMPLE_FIELD_NAME, "value1")), this.simpleType.asValue(v -> v.putField(SIMPLE_FIELD_NAME, "value2"))}));
    }

    @Test
    void putFieldCustomArrayNonExistingField() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.instance.putField("not a field name", new TypedValue[]{this.simpleType.asValue(v -> v.putField(SIMPLE_FIELD_NAME, "value1")), this.simpleType.asValue(v -> v.putField(SIMPLE_FIELD_NAME, "value2"))}));
    }

    @Test
    void putFieldCustomArrayInvalidValues() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.instance.putField(CUSTOM_FIELD_ARRAY_NAME, new TypedValue[]{this.longType.asValue(1), this.longType.asValue(2)}));
    }

    @Test
    void putFieldCustomInvalid() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.instance.putField(CUSTOM_FIELD_NAME, 0L));
    }

    @Test
    public void putFieldCustomBuilderArray() {
        TypedFieldValue value = (TypedFieldValue)this.instance.putFields(CUSTOM_FIELD_ARRAY_NAME, fld1 -> fld1.putField(SIMPLE_FIELD_NAME, SIMPLE_FIELD_VALUE), fld2 -> fld2.putField(SIMPLE_FIELD_NAME, SIMPLE_FIELD_VALUE), new Consumer[0]).build().get(CUSTOM_FIELD_ARRAY_NAME);
        Assertions.assertEquals((Object)CUSTOM_FIELD_ARRAY_NAME, (Object)value.getField().getName());
        Assertions.assertNotNull((Object)value);
    }

    @Test
    public void putFieldCustomBuilderArrayNonArrayField() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.instance.putFields(CUSTOM_FIELD_NAME, fld1 -> fld1.putField(SIMPLE_FIELD_NAME, SIMPLE_FIELD_VALUE), fld2 -> fld2.putField(SIMPLE_FIELD_NAME, SIMPLE_FIELD_VALUE), new Consumer[0]).build().get(CUSTOM_FIELD_ARRAY_NAME));
    }

    @Test
    public void putFieldCustomBuilderArrayNonExistingField() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.instance.putFields("not a field name", fld1 -> fld1.putField(SIMPLE_FIELD_NAME, SIMPLE_FIELD_VALUE), fld2 -> fld2.putField(SIMPLE_FIELD_NAME, SIMPLE_FIELD_VALUE), new Consumer[0]).build().get(CUSTOM_FIELD_ARRAY_NAME));
    }

    private void assertCorrectFieldValueBuiltinType(Types.Builtin target, Types.Builtin type, int value, boolean asArray) {
        if (asArray) {
            this.testPutBuiltinFieldArray(target, TypedValueBuilderImplTest.getArrayFieldName(type), value);
        } else {
            this.testPutBuiltinField(target, TypedValueBuilderImplTest.getFieldName(type), value);
        }
        String fieldName = asArray ? TypedValueBuilderImplTest.getArrayFieldName(type) : TypedValueBuilderImplTest.getFieldName(type);
        TypedFieldValueImpl fieldValue = (TypedFieldValueImpl)this.instance.build().get(fieldName);
        Assertions.assertNotNull((Object)fieldValue);
        Assertions.assertEquals((Object)fieldName, (Object)fieldValue.getField().getName());
        Object targetValue = null;
        if (asArray) {
            TypedValueImpl[] targetValues = fieldValue.getValues();
            Assertions.assertNotNull((Object)targetValues);
            Assertions.assertTrue((boolean)targetValues.getClass().isArray());
            targetValue = Array.get(targetValues, 0);
        } else {
            targetValue = fieldValue.getValue().getValue();
        }
        Assertions.assertNotNull((Object)targetValue);
        if (targetValue instanceof Number) {
            Assertions.assertEquals((int)value, (int)((Number)targetValue).intValue());
        } else if (targetValue instanceof String) {
            Assertions.assertEquals((Object)String.valueOf(value), (Object)targetValue);
        } else if (targetValue instanceof Boolean) {
            Assertions.assertEquals((Object)(value > 0 ? 1 : 0), (Object)targetValue);
        }
    }

    private void assertWrongFieldValueBuiltinType(Types.Builtin target, Types.Builtin type, int value) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testPutBuiltinField(target, TypedValueBuilderImplTest.getArrayFieldName(type), value));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testPutBuiltinFieldArray(target, TypedValueBuilderImplTest.getFieldName(type), value));
    }

    private void testPutBuiltinField(Types.Builtin target, String fieldName, int value) {
        switch (target) {
            case BYTE: {
                this.instance.putField(fieldName, (byte)value);
                break;
            }
            case CHAR: {
                this.instance.putField(fieldName, (char)value);
                break;
            }
            case SHORT: {
                this.instance.putField(fieldName, (short)value);
                break;
            }
            case INT: {
                this.instance.putField(fieldName, value);
                break;
            }
            case LONG: {
                this.instance.putField(fieldName, (long)value);
                break;
            }
            case FLOAT: {
                this.instance.putField(fieldName, (float)value);
                break;
            }
            case DOUBLE: {
                this.instance.putField(fieldName, (double)value);
                break;
            }
            case BOOLEAN: {
                this.instance.putField(fieldName, value > 0);
                break;
            }
            case STRING: {
                this.instance.putField(fieldName, String.valueOf(value));
            }
        }
    }

    private void testPutBuiltinFieldArray(Types.Builtin target, String fieldName, int value) {
        switch (target) {
            case BYTE: {
                this.instance.putField(fieldName, new byte[]{(byte)value});
                break;
            }
            case CHAR: {
                this.instance.putField(fieldName, new char[]{(char)value});
                break;
            }
            case SHORT: {
                this.instance.putField(fieldName, new short[]{(short)value});
                break;
            }
            case INT: {
                this.instance.putField(fieldName, new int[]{value});
                break;
            }
            case LONG: {
                this.instance.putField(fieldName, new long[]{value});
                break;
            }
            case FLOAT: {
                this.instance.putField(fieldName, new float[]{value});
                break;
            }
            case DOUBLE: {
                this.instance.putField(fieldName, new double[]{value});
                break;
            }
            case BOOLEAN: {
                this.instance.putField(fieldName, new boolean[]{value > 0});
                break;
            }
            case STRING: {
                this.instance.putField(fieldName, new String[]{String.valueOf(value)});
            }
        }
    }

    private static String getFieldName(Types.Builtin type) {
        return typeToFieldMap.get(type);
    }

    private static String getArrayFieldName(Types.Builtin type) {
        return TypedValueBuilderImplTest.getFieldName(type) + "_arr";
    }
}

