/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.MetadataImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

class TypedFieldValueTest {
    private TypesImpl types;

    TypedFieldValueTest() {
    }

    @BeforeEach
    void setup() {
        this.types = new TypesImpl(new MetadataImpl(new ConstantPools()));
    }

    @Test
    void testArrayForScalarField() {
        TypeImpl type = this.types.getType((Types.Predefined)Types.Builtin.STRING);
        TypedFieldImpl field = new TypedFieldImpl(type, "field");
        TypedValueImpl value = type.asValue("hello");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TypedFieldValueImpl(field, new TypedValueImpl[]{value, value}));
    }

    @Test
    void testScalarValue() {
        TypeImpl type = this.types.getType((Types.Predefined)Types.Builtin.STRING);
        TypedFieldImpl field = new TypedFieldImpl(type, "field");
        TypedValueImpl value = type.asValue("hello");
        TypedFieldValueImpl instance = new TypedFieldValueImpl(field, value);
        Assertions.assertNotNull((Object)instance.getValue());
        Assertions.assertEquals((Object)field, (Object)instance.getField());
        Assertions.assertEquals((Object)value, (Object)instance.getValue());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((TypedFieldValueImpl)instance).getValues());
    }

    @Test
    void testArrayValue() {
        TypeImpl type = this.types.getType((Types.Predefined)Types.Builtin.STRING);
        TypedFieldImpl field = new TypedFieldImpl(type, "field", true);
        TypedValueImpl value1 = type.asValue("hello");
        TypedValueImpl value2 = type.asValue("world");
        TypedFieldValueImpl instance = new TypedFieldValueImpl(field, new TypedValueImpl[]{value1, value2});
        Assertions.assertNotNull((Object)instance.getValues());
        Assertions.assertEquals((Object)field, (Object)instance.getField());
        Assertions.assertArrayEquals((Object[])new TypedValueImpl[]{value1, value2}, (Object[])instance.getValues());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((TypedFieldValueImpl)instance).getValue());
    }
}

