/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.MetadataImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.Types;
import org.openjdk.jmc.flightrecorder.writer.util.TypeByUsageComparator;

class TypeByUsageComparatorTest {
    private TypesImpl types;
    private TypeByUsageComparator instance;

    TypeByUsageComparatorTest() {
    }

    @BeforeEach
    void setup() {
        ConstantPools constantPools = new ConstantPools();
        MetadataImpl metadata = new MetadataImpl(constantPools);
        this.types = new TypesImpl(metadata);
        this.instance = new TypeByUsageComparator();
    }

    @Test
    void compare() {
        TypeImpl type1 = this.types.getType((Types.Predefined)Types.Builtin.STRING);
        TypeImpl type2 = this.types.getType((Types.Predefined)Types.JDK.CLASS);
        Assertions.assertEquals((int)0, (int)this.instance.compare((Type)type1, (Type)type1));
        Assertions.assertEquals((int)0, (int)this.instance.compare((Type)type2, (Type)type2));
        Assertions.assertEquals((int)0, (int)this.instance.compare(null, null));
        Assertions.assertEquals((int)1, (int)this.instance.compare((Type)type1, null));
        Assertions.assertEquals((int)-1, (int)this.instance.compare(null, (Type)type1));
        Assertions.assertEquals((int)-1, (int)this.instance.compare((Type)type1, (Type)type2));
        Assertions.assertEquals((int)1, (int)this.instance.compare((Type)type2, (Type)type1));
    }
}

