/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.InvalidType;
import org.openjdk.jmc.flightrecorder.writer.MetadataImpl;
import org.openjdk.jmc.flightrecorder.writer.ResolvableType;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeStructureImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.NamedType;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

class ResolvableTypeTest {
    private static final String FIELD_1_NAME = "field_1";
    private static final String FIELD_2_NAME = "field_2";
    private ResolvableType resolvableType;
    private final String targetTypeName = "custom.Type";
    private MetadataImpl metadata;
    private TypesImpl types;
    private TypeImpl targetType;

    ResolvableTypeTest() {
    }

    @BeforeEach
    void setUp() {
        ConstantPools constantPools = new ConstantPools();
        this.metadata = new MetadataImpl(constantPools);
        this.types = new TypesImpl(this.metadata);
        this.resolvableType = new ResolvableType("custom.Type", this.metadata);
    }

    @Test
    void isResolved() {
        Assertions.assertFalse((boolean)this.resolvableType.isResolved());
        this.resolve();
        Assertions.assertTrue((boolean)this.resolvableType.isResolved());
    }

    @Test
    void getId() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.getId());
        this.resolve();
        Assertions.assertEquals((long)this.targetType.getId(), (long)this.resolvableType.getId());
    }

    @Test
    void hasConstantPool() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.hasConstantPool());
        this.resolve();
        Assertions.assertEquals((Object)this.targetType.hasConstantPool(), (Object)this.resolvableType.hasConstantPool());
    }

    @Test
    void asValueByte() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.asValue((byte)1));
        this.resolve();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.resolvableType.asValue((byte)1));
    }

    @Test
    void asValueChar() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.asValue('\u0001'));
        this.resolve();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.resolvableType.asValue('\u0001'));
    }

    @Test
    void asValueShort() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.asValue((short)1));
        this.resolve();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.resolvableType.asValue((short)1));
    }

    @Test
    void asValueInt() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.asValue(1));
        this.resolve();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.resolvableType.asValue(1));
    }

    @Test
    void asValueLong() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.asValue(1L));
        this.resolve();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.resolvableType.asValue(1L));
    }

    @Test
    void asValueFloat() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.asValue(1.0f));
        this.resolve();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.resolvableType.asValue(1.0f));
    }

    @Test
    void asValueDouble() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.asValue(1.0));
        this.resolve();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.resolvableType.asValue(1.0));
    }

    @Test
    void asValueBoolean() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.asValue(true));
        this.resolve();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.resolvableType.asValue(true));
    }

    @Test
    void asValueString() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.asValue("1"));
        this.resolve();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.resolvableType.asValue("1"));
    }

    @Test
    void asValueCustom() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.asValue(v -> {}));
        this.resolve();
        TypedValueImpl value1 = this.targetType.asValue(v -> {});
        TypedValueImpl value2 = this.resolvableType.asValue(v -> {});
        Assertions.assertEquals((Object)value1, (Object)value2);
    }

    @Test
    void nullValue() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.nullValue());
        this.resolve();
        Assertions.assertEquals((Object)this.targetType.nullValue(), (Object)this.resolvableType.nullValue());
    }

    @Test
    void isBuiltin() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.isBuiltin());
        this.resolve();
        Assertions.assertEquals((Object)this.targetType.isBuiltin(), (Object)this.resolvableType.isBuiltin());
    }

    @Test
    void isSimple() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.isSimple());
        this.resolve();
        Assertions.assertEquals((Object)this.targetType.isSimple(), (Object)this.resolvableType.isSimple());
    }

    @Test
    void getSupertype() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.getSupertype());
        this.resolve();
        Assertions.assertEquals((Object)this.targetType.getSupertype(), (Object)this.resolvableType.getSupertype());
    }

    @Test
    void getFields() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.getFields());
        this.resolve();
        Assertions.assertEquals((Object)this.targetType.getFields(), (Object)this.resolvableType.getFields());
    }

    @Test
    void getField() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.getField(FIELD_1_NAME));
        this.resolve();
        Assertions.assertEquals((Object)this.targetType.getField(FIELD_1_NAME), (Object)this.resolvableType.getField(FIELD_1_NAME));
    }

    @Test
    void getAnnotations() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.getAnnotations());
        this.resolve();
        Assertions.assertEquals((Object)this.targetType.getAnnotations(), (Object)this.resolvableType.getAnnotations());
    }

    @Test
    void canAccept() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.canAccept((Object)"value"));
        this.resolve();
        Assertions.assertEquals((Object)this.targetType.canAccept((Object)"value"), (Object)this.resolvableType.canAccept((Object)"value"));
    }

    @Test
    void getTypeName() {
        Assertions.assertEquals((Object)"custom.Type", (Object)this.resolvableType.getTypeName());
        this.resolve();
        Assertions.assertEquals((Object)this.targetType.getFields(), (Object)this.resolvableType.getFields());
    }

    @Test
    void isSame() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.isSame((NamedType)Types.JDK.CLASS_LOADER));
        this.resolve();
        Assertions.assertEquals((Object)this.targetType.isSame((NamedType)Types.JDK.CLASS_LOADER), (Object)this.resolvableType.isSame((NamedType)Types.JDK.CLASS_LOADER));
    }

    @Test
    void isUsedBy() {
        TypeImpl otherType = this.types.getType((Types.Predefined)Types.JDK.CLASS_LOADER);
        Assertions.assertThrows(IllegalStateException.class, () -> this.resolvableType.isUsedBy((Type)otherType));
        this.resolve();
        Assertions.assertEquals((Object)this.targetType.isUsedBy((Type)otherType), (Object)this.resolvableType.isUsedBy((Type)otherType));
    }

    @Test
    void wrongTypeResolve() {
        MetadataImpl mockedMetadata = (MetadataImpl)Mockito.mock(MetadataImpl.class);
        Mockito.when((Object)mockedMetadata.getType(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new InvalidType());
        Assertions.assertFalse((boolean)this.resolvableType.resolve());
    }

    private void resolve() {
        List<TypedFieldImpl> fields = Arrays.asList(new TypedFieldImpl(this.types.getType((Types.Predefined)Types.Builtin.STRING), FIELD_1_NAME), new TypedFieldImpl(this.types.getType((Types.Predefined)Types.Builtin.LONG), FIELD_2_NAME));
        this.targetType = this.metadata.registerType("custom.Type", null, () -> new TypeStructureImpl(fields, Collections.emptyList()));
        this.metadata.resolveTypes();
    }
}

