/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.Collections;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.MetadataImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeStructureImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

public class MetadataImplTest {
    private static final String TYPE_NAME = "dummy.Type";
    private MetadataImpl instance;

    @BeforeEach
    public void setup() throws Exception {
        this.instance = new MetadataImpl(new ConstantPools());
    }

    @Test
    public void registerBuiltinNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.instance.registerBuiltin(null));
    }

    @Test
    public void registerBuiltin() {
        for (Types.Builtin builtin : Types.Builtin.values()) {
            this.instance.registerBuiltin(builtin);
            Assertions.assertNotNull((Object)this.instance.getType(builtin.getTypeName(), false));
        }
    }

    @Test
    public void resolveTypes() {
        TypeImpl resolvable = this.instance.getType(TYPE_NAME, true);
        Assertions.assertFalse((boolean)resolvable.isResolved());
        Assertions.assertEquals((Object)TYPE_NAME, (Object)resolvable.getTypeName());
        this.instance.registerType(TYPE_NAME, null, () -> new TypeStructureImpl(Collections.emptyList(), Collections.emptyList()));
        this.instance.resolveTypes();
        Assertions.assertTrue((boolean)resolvable.isResolved());
        Assertions.assertEquals((Object)TYPE_NAME, (Object)resolvable.getTypeName());
    }

    @Test
    public void registerTypeNullStructureProvider() {
        Assertions.assertNotNull((Object)this.instance.registerType(TYPE_NAME, "type.Super", (Supplier)null));
    }

    @Test
    public void registerType() {
        TypeImpl type = this.instance.registerType(TYPE_NAME, "type.Super", () -> TypeStructureImpl.EMPTY);
        Assertions.assertNotNull((Object)type);
        Assertions.assertNotNull((Object)type.getFields());
        Assertions.assertNotNull((Object)type.getAnnotations());
    }

    @Test
    public void getTypeEmptyMetadata() {
        Assertions.assertNull((Object)this.instance.getType(TYPE_NAME, false));
    }

    @Test
    public void getResolvableTypeEmptyMetadata() {
        Assertions.assertNotNull((Object)this.instance.getType(TYPE_NAME, true));
    }

    @Test
    void createInvalidBuiltinType() {
        String typeName = "invalid";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.instance.createBuiltinType(typeName));
    }

    @Test
    void createValidBuiltinType() {
        String typeName = Types.Builtin.BYTE.getTypeName();
        TypeImpl type = this.instance.createBuiltinType(typeName);
        Assertions.assertNotNull((Object)type);
        Assertions.assertTrue((boolean)type.isBuiltin());
        Assertions.assertEquals((Object)typeName, (Object)type.getTypeName());
    }

    @Test
    void createDuplicateBuiltinType() {
        String typeName = Types.Builtin.BYTE.getTypeName();
        TypeImpl type1 = this.instance.createBuiltinType(typeName);
        Assertions.assertNotNull((Object)type1);
        Assertions.assertTrue((boolean)type1.isBuiltin());
        TypeImpl type2 = this.instance.createBuiltinType(typeName);
        Assertions.assertNotNull((Object)type2);
        Assertions.assertTrue((boolean)type2.isBuiltin());
        Assertions.assertEquals((Object)type1.getTypeName(), (Object)type2.getTypeName());
        Assertions.assertNotEquals((Object)type1, (Object)type2);
    }

    @Test
    void createCustomTypeForBuiltin() {
        String typeName = Types.Builtin.BYTE.getTypeName();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.instance.createCustomType(typeName, null, TypeStructureImpl.EMPTY, true));
    }

    @Test
    void createCustomTypeNullStructure() {
        String typeName = "dummy.Test";
        TypeImpl type = this.instance.createCustomType(typeName, null, null, true);
        Assertions.assertNotNull((Object)type);
        Assertions.assertFalse((boolean)type.isBuiltin());
        Assertions.assertEquals((Object)typeName, (Object)type.getTypeName());
        Assertions.assertNotNull((Object)type.getFields());
        Assertions.assertNotNull((Object)type.getAnnotations());
    }

    @Test
    void createCustomType() {
        String typeName = "dummy.Test";
        String superName = "super.Type";
        for (boolean withCp : new boolean[]{true, false}) {
            TypeImpl type = this.instance.createCustomType(typeName, superName, TypeStructureImpl.EMPTY, withCp);
            Assertions.assertNotNull((Object)type);
            Assertions.assertFalse((boolean)type.isBuiltin());
            Assertions.assertEquals((Object)typeName, (Object)type.getTypeName());
            Assertions.assertNotNull((Object)type.getFields());
            Assertions.assertNotNull((Object)type.getAnnotations());
            Assertions.assertEquals((Object)superName, (Object)type.getSupertype());
            Assertions.assertEquals((Object)withCp, (Object)type.hasConstantPool());
        }
    }

    @Test
    void createDuplicateCustomType() {
        String typeName = "dummy.Test";
        String superName = "super.Type";
        TypeImpl type1 = this.instance.createCustomType(typeName, superName, TypeStructureImpl.EMPTY, true);
        Assertions.assertNotNull((Object)type1);
        Assertions.assertFalse((boolean)type1.isBuiltin());
        TypeImpl type2 = this.instance.createCustomType(typeName, superName, TypeStructureImpl.EMPTY, true);
        Assertions.assertNotNull((Object)type2);
        Assertions.assertFalse((boolean)type2.isBuiltin());
        Assertions.assertEquals((Object)type1.getTypeName(), (Object)type2.getTypeName());
        Assertions.assertNotEquals((Object)type1, (Object)type2);
    }

    @Test
    void stringIndexNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.instance.stringIndex(null));
    }
}

