/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;

class ConstantPoolsTest {
    private ConstantPools instance;
    private TypeImpl type1;
    private TypeImpl type2;

    ConstantPoolsTest() {
    }

    @BeforeEach
    void setUp() {
        this.instance = new ConstantPools();
        this.type1 = (TypeImpl)Mockito.mock(TypeImpl.class);
        this.type2 = (TypeImpl)Mockito.mock(TypeImpl.class);
    }

    @Test
    void forTypeWithCP() {
        Mockito.when((Object)this.type1.hasConstantPool()).thenReturn((Object)true);
        Assertions.assertNotNull((Object)this.instance.forType(this.type1));
    }

    @Test
    void forTypeWithoutCP() {
        Mockito.when((Object)this.type1.hasConstantPool()).thenReturn((Object)false);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.instance.forType(this.type1));
    }

    @Test
    void size() {
        Assertions.assertEquals((int)0, (int)this.instance.size());
        this.addConstantPool();
        Assertions.assertEquals((int)2, (int)this.instance.size());
    }

    @Test
    void iteratorEmpty() {
        Iterator iterator = this.instance.iterator();
        Assertions.assertNotNull((Object)iterator);
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void iterator() {
        this.addConstantPool();
        Iterator iterator = this.instance.iterator();
        Assertions.assertNotNull((Object)iterator);
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertNotNull(iterator.next());
    }

    @Test
    void spliteratorEmpty() {
        Spliterator iterator = this.instance.spliterator();
        Assertions.assertNotNull((Object)iterator);
        AtomicReference pool = new AtomicReference();
        Assertions.assertFalse((boolean)iterator.tryAdvance(pool::set));
        Assertions.assertNull(pool.get());
    }

    @Test
    void spliterator() {
        this.addConstantPool();
        Spliterator iterator = this.instance.spliterator();
        Assertions.assertNotNull((Object)iterator);
        AtomicReference pool = new AtomicReference();
        Assertions.assertTrue((boolean)iterator.tryAdvance(pool::set));
        Assertions.assertNotNull(pool.get());
    }

    @Test
    void forEachEmpty() {
        AtomicInteger cntr = new AtomicInteger();
        this.instance.forEach(cp -> cntr.incrementAndGet());
        Assertions.assertEquals((int)0, (int)cntr.get());
    }

    @Test
    void forEach() {
        this.addConstantPool();
        AtomicInteger cntr = new AtomicInteger();
        this.instance.forEach(cp -> cntr.incrementAndGet());
        Assertions.assertNotEquals((int)0, (int)cntr.get());
    }

    private void addConstantPool() {
        Mockito.when((Object)this.type1.hasConstantPool()).thenReturn((Object)true);
        Mockito.when((Object)this.type2.hasConstantPool()).thenReturn((Object)true);
        this.instance.forType(this.type1);
        this.instance.forType(this.type2);
    }
}

