/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openjdk.jmc.flightrecorder.writer.ConstantPool;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.LEB128Writer;
import org.openjdk.jmc.flightrecorder.writer.MetadataImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

class ConstantPoolWriterTest {
    private ConstantPools constantPools;
    private TypesImpl types;
    private LEB128Writer writer;
    private TypeImpl customType;
    private ConstantPool instance;

    ConstantPoolWriterTest() {
    }

    @BeforeEach
    void setup() {
        this.constantPools = new ConstantPools();
        MetadataImpl metadata = new MetadataImpl(this.constantPools);
        this.types = new TypesImpl(metadata);
        this.writer = LEB128Writer.getInstance();
        this.customType = this.types.getOrAdd("custom.Type", t -> t.addField("field", (Types.Predefined)Types.Builtin.STRING));
        this.instance = new ConstantPool(this.customType);
    }

    @Test
    void writeNull() {
        for (boolean useCpFlag : new boolean[]{true, false}) {
            Assertions.assertThrows(NullPointerException.class, () -> this.instance.writeValueType(this.writer, null, useCpFlag));
            Assertions.assertThrows(NullPointerException.class, () -> this.instance.writeBuiltinType(this.writer, null, useCpFlag));
        }
    }

    @Test
    void writeNullValue() {
        for (boolean useCpFlag : new boolean[]{true, false}) {
            this.instance.writeValueType(this.writer, this.customType.nullValue(), useCpFlag);
            for (Types.Builtin builtin : Types.Builtin.values()) {
                this.instance.writeBuiltinType(this.writer, this.types.getType((Types.Predefined)builtin).nullValue(), useCpFlag);
            }
        }
    }

    @Test
    void writeBuiltinByte() {
        for (boolean useCpFlag : new boolean[]{true, false}) {
            this.instance.writeBuiltinType(this.writer, this.types.getType((Types.Predefined)Types.Builtin.BYTE).asValue((byte)1), useCpFlag);
        }
    }

    @Test
    void writeBuiltinChar() {
        for (boolean useCpFlag : new boolean[]{true, false}) {
            this.instance.writeBuiltinType(this.writer, this.types.getType((Types.Predefined)Types.Builtin.CHAR).asValue('\u0001'), useCpFlag);
        }
    }

    @Test
    void writeBuiltinShort() {
        for (boolean useCpFlag : new boolean[]{true, false}) {
            this.instance.writeBuiltinType(this.writer, this.types.getType((Types.Predefined)Types.Builtin.SHORT).asValue((short)1), useCpFlag);
        }
    }

    @Test
    void writeBuiltinInt() {
        for (boolean useCpFlag : new boolean[]{true, false}) {
            this.instance.writeBuiltinType(this.writer, this.types.getType((Types.Predefined)Types.Builtin.INT).asValue(1), useCpFlag);
        }
    }

    @Test
    void writeBuiltinLong() {
        for (boolean useCpFlag : new boolean[]{true, false}) {
            this.instance.writeBuiltinType(this.writer, this.types.getType((Types.Predefined)Types.Builtin.LONG).asValue(1L), useCpFlag);
        }
    }

    @Test
    void writeBuiltinFloat() {
        for (boolean useCpFlag : new boolean[]{true, false}) {
            this.instance.writeBuiltinType(this.writer, this.types.getType((Types.Predefined)Types.Builtin.FLOAT).asValue(1.0f), useCpFlag);
        }
    }

    @Test
    void writeBuiltinDouble() {
        for (boolean useCpFlag : new boolean[]{true, false}) {
            this.instance.writeBuiltinType(this.writer, this.types.getType((Types.Predefined)Types.Builtin.DOUBLE).asValue(1.0), useCpFlag);
        }
    }

    @Test
    void writeBuiltinBoolean() {
        for (boolean useCpFlag : new boolean[]{true, false}) {
            this.instance.writeBuiltinType(this.writer, this.types.getType((Types.Predefined)Types.Builtin.BOOLEAN).asValue(true), useCpFlag);
        }
    }

    @Test
    void writeBuiltinString() {
        for (boolean useCpFlag : new boolean[]{true, false}) {
            this.instance.writeBuiltinType(this.writer, this.types.getType((Types.Predefined)Types.Builtin.STRING).asValue("1"), useCpFlag);
        }
    }

    @Test
    void writeCustomAsBuiltin() {
        TypedValueImpl value = this.customType.asValue(v -> v.putField("field", "value"));
        for (boolean useCpFlag : new boolean[]{true, false}) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.instance.writeBuiltinType(this.writer, value, useCpFlag));
        }
    }

    @Test
    void writeString() {
        TypeImpl type = this.types.getType((Types.Predefined)Types.Builtin.STRING);
        for (boolean useCpFlag : new boolean[]{true, false}) {
            for (String strVal : new String[]{null, "", "value"}) {
                this.instance.writeBuiltinType(this.writer, type.asValue(strVal), useCpFlag);
            }
        }
    }
}

