/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.openjdk.jmc.flightrecorder.writer.ConstantPool;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;

class ConstantPoolTest {
    private ConstantPool instance;

    ConstantPoolTest() {
    }

    @BeforeEach
    void setUp() {
        TypeImpl type = (TypeImpl)Mockito.mock(TypeImpl.class);
        Mockito.when((Object)type.canAccept(ArgumentMatchers.any())).thenReturn((Object)true);
        TypedValueImpl nullValue = new TypedValueImpl(type, null, 0L);
        Mockito.when((Object)type.nullValue()).thenReturn((Object)nullValue);
        this.instance = new ConstantPool(type);
    }

    @Test
    void addOrGetNull() {
        TypedValueImpl value = this.instance.addOrGet(null);
        Assertions.assertNotNull((Object)value);
        Assertions.assertTrue((boolean)value.isNull());
    }

    @Test
    void addOrGetNonNull() {
        String objectValue = "hello";
        TypedValueImpl value = this.instance.addOrGet((Object)objectValue);
        Assertions.assertNotNull((Object)value);
        Assertions.assertFalse((boolean)value.isNull());
        Assertions.assertEquals((Object)objectValue, (Object)value.getValue());
    }

    @Test
    void getNegativeIndex() {
        Assertions.assertNull((Object)this.instance.get(-1L));
    }

    @Test
    void getNonExistent() {
        Assertions.assertNull((Object)this.instance.get(100L));
    }

    @Test
    void get() {
        String objectValue = "hello";
        TypedValueImpl value = this.instance.addOrGet((Object)objectValue);
        Assertions.assertEquals((Object)value, (Object)this.instance.get(value.getConstantPoolIndex()));
    }
}

