/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.lookup;

import org.jemmy.Rectangle;
import org.jemmy.control.Wrap;
import org.jemmy.lookup.CoordinateLookup;

public abstract class RelativeCoordinateLookup<CONTROL>
extends CoordinateLookup<CONTROL> {
    private static final int MAX_SCREEN_SIZE = 100000;
    private Wrap wrap;
    private boolean includeControl;
    private int hr;
    private int vr;

    public RelativeCoordinateLookup(Wrap wrap, boolean includeControl, int hr, int vr) {
        super(wrap.getScreenBounds());
        this.wrap = wrap;
        this.includeControl = includeControl;
        this.hr = hr;
        this.vr = vr;
    }

    @Override
    protected Rectangle getArea() {
        return RelativeCoordinateLookup.constructArea(this.wrap, this.includeControl, this.hr, this.vr);
    }

    private static Rectangle constructArea(Wrap wrap, boolean includeControl, int hr, int vr) {
        Rectangle res = new Rectangle();
        res.width = 100000;
        res.height = 100000;
        Rectangle bounds = wrap.getScreenBounds();
        res.x = hr != 0 ? (hr < 0 ? -100000 + bounds.x + (includeControl ? bounds.width : 0) : bounds.x + (includeControl ? 0 : bounds.width)) : -50000 + bounds.x + (includeControl ? bounds.width / 2 : 0);
        res.y = vr != 0 ? (vr < 0 ? -100000 + bounds.y + (includeControl ? bounds.height : 0) : bounds.y + (includeControl ? 0 : bounds.height)) : -50000 + bounds.y + (includeControl ? bounds.height / 2 : 0);
        return res;
    }
}

