/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.input;

import org.jemmy.action.Action;
import org.jemmy.control.Wrap;
import org.jemmy.interfaces.Focusable;
import org.jemmy.interfaces.Keyboard;
import org.jemmy.interfaces.Text;
import org.jemmy.timing.State;

public abstract class TextImpl
implements Text {
    private static final int DEFAULT_SELECT_ALL_CLICK_COUNT = 3;
    private Wrap<?> target;
    private int selectAllClickCount = 3;
    boolean keyboardSelection;

    protected TextImpl(Wrap<?> target, boolean keyboardSelection) {
        this.target = target;
        this.keyboardSelection = keyboardSelection;
    }

    protected TextImpl(Wrap<?> target) {
        this(target, false);
    }

    public Wrap<?> getWrap() {
        return this.target;
    }

    @Override
    public void type(final String newText) {
        this.target.getEnvironment().getExecutor().execute(this.target.getEnvironment(), false, new Action(){

            @Override
            public void run(Object ... parameters) {
                if (TextImpl.this.target.is(Focusable.class)) {
                    TextImpl.this.target.as(Focusable.class).focuser().focus();
                }
                char[] chars = newText.toCharArray();
                Keyboard kb = TextImpl.this.target.keyboard();
                for (char c : chars) {
                    kb.typeChar(c);
                }
                TextImpl.this.target.getEnvironment().getWaiter(Wrap.WAIT_STATE_TIMEOUT.getName()).ensureState(new State<Object>(){

                    @Override
                    public Object reached() {
                        return TextImpl.this.text().contains(newText) ? "" : null;
                    }

                    public String toString() {
                        return "text() equals '" + newText + "', text() = '" + TextImpl.this.text() + "'";
                    }
                });
            }

            @Override
            public String toString() {
                return "typing text \"" + newText + "\"";
            }
        }, new Object[0]);
    }

    protected void selectAll() {
        if (!this.keyboardSelection) {
            this.target.mouse().click(this.selectAllClickCount, this.target.getClickPoint());
        } else {
            Keyboard kbrd = this.target.keyboard();
            kbrd.pushKey(Keyboard.KeyboardButtons.HOME);
            kbrd.pushKey(Keyboard.KeyboardButtons.END, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
            kbrd.pushKey(Keyboard.KeyboardButtons.DELETE);
        }
    }

    @Override
    public void clear() {
        this.target.getEnvironment().getExecutor().execute(this.target.getEnvironment(), false, new Action(){

            @Override
            public void run(Object ... parameters) {
                String text;
                if (TextImpl.this.target.is(Focusable.class)) {
                    TextImpl.this.target.as(Focusable.class).focuser().focus();
                }
                if ((text = TextImpl.this.text()) == null) {
                    return;
                }
                TextImpl.this.target.keyboard().pushKey(Keyboard.KeyboardButtons.END);
                while (!text.isEmpty() && this.withinAllowedTime()) {
                    TextImpl.this.target.keyboard().pushKey(Keyboard.KeyboardButtons.BACK_SPACE);
                    TextImpl.this.target.keyboard().pushKey(Keyboard.KeyboardButtons.DELETE);
                    text = TextImpl.this.text();
                }
            }

            @Override
            public String toString() {
                return "clearing text";
            }
        }, new Object[0]);
    }
}

