/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.image.pixel;

import java.io.File;
import java.io.IOException;
import org.jemmy.image.Image;
import org.jemmy.image.ImageStore;
import org.jemmy.image.pixel.PNGSaver;
import org.jemmy.image.pixel.Raster;

public class PNGFileImageStore
implements ImageStore {
    private final File root;

    public PNGFileImageStore(File root) {
        this.root = root;
    }

    public PNGFileImageStore() {
        this(null);
    }

    @Override
    public void save(Image image, String id) throws IOException {
        File file;
        File parentDir;
        if (!(image instanceof Raster)) {
            throw new IllegalArgumentException("This implementation only takes rasters");
        }
        if (this.root != null) {
            id = this.root.getAbsolutePath() + File.separator + id;
        }
        if ((parentDir = (file = new File(id)).getParentFile()) != null) {
            parentDir.mkdirs();
        }
        new PNGSaver(file).encode((Raster)((Object)image));
    }

    public File getRoot() {
        return this.root;
    }
}

