/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.manager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.p2.resolver.facade.P2ResolverFactory;
import org.eclipse.tycho.p2.target.P2TargetPlatform;
import org.eclipse.tycho.p2.target.PreliminaryTargetPlatformImpl;
import org.eclipse.tycho.p2.target.TargetPlatformFactoryImpl;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.p2.target.facade.TargetPlatformFactory;
import org.eclipse.tycho.repository.module.PublishingRepositoryImpl;
import org.eclipse.tycho.repository.publishing.PublishingRepository;
import org.eclipse.tycho.repository.registry.ReactorRepositoryManager;

public class ReactorRepositoryManagerImpl
implements ReactorRepositoryManager {
    private static final String PRELIMINARY_TARGET_PLATFORM_KEY = String.valueOf(ReactorRepositoryManagerImpl.class.getName()) + "/dependencyOnlyTargetPlatform";
    private static final String FINAL_TARGET_PLATFORM_KEY = "org.eclipse.tycho.core.TychoConstants/targetPlatform";
    private IProvisioningAgentProvider agentFactory;
    private File agentDir;
    private IProvisioningAgent agent;
    private TargetPlatformFactory tpFactory;

    public void bindProvisioningAgentFactory(IProvisioningAgentProvider agentFactory) {
        this.agentFactory = agentFactory;
    }

    public void bindP2ResolverFactory(P2ResolverFactory p2ResolverFactory) {
        this.tpFactory = p2ResolverFactory.getTargetPlatformFactory();
    }

    public void activateManager() throws IOException, ProvisionException {
        this.agentDir = ReactorRepositoryManagerImpl.createTempDir("tycho_reactor_agent");
        this.agent = this.agentFactory.createAgent(this.agentDir.toURI());
    }

    public void deactivateManager() {
        this.agent.stop();
        FileUtils.deleteAll((File)this.agentDir);
    }

    public IProvisioningAgent getAgent() {
        return this.agent;
    }

    public PublishingRepository getPublishingRepository(ReactorProjectIdentities project) {
        return new PublishingRepositoryImpl(this.agent, project);
    }

    public TargetPlatform computePreliminaryTargetPlatform(ReactorProject project, TargetPlatformConfigurationStub tpConfiguration, ExecutionEnvironmentConfiguration eeConfiguration, List<ReactorProject> reactorProjects, PomDependencyCollector pomDependencies) {
        TargetPlatform result = this.tpFactory.createTargetPlatform(tpConfiguration, eeConfiguration, reactorProjects, pomDependencies);
        project.setContextValue(PRELIMINARY_TARGET_PLATFORM_KEY, (Object)result);
        return result;
    }

    public void computeFinalTargetPlatform(ReactorProject project, List<? extends ReactorProjectIdentities> upstreamProjects) {
        PreliminaryTargetPlatformImpl preliminaryTargetPlatform = this.getRegisteredPreliminaryTargetPlatform(project);
        if (preliminaryTargetPlatform == null) {
            return;
        }
        List<PublishingRepository> upstreamProjectResults = this.getBuildResults(upstreamProjects);
        P2TargetPlatform result = ((TargetPlatformFactoryImpl)this.tpFactory).createTargetPlatformWithUpdatedReactorContent(preliminaryTargetPlatform, upstreamProjectResults);
        project.setContextValue(FINAL_TARGET_PLATFORM_KEY, (Object)result);
    }

    private PreliminaryTargetPlatformImpl getRegisteredPreliminaryTargetPlatform(ReactorProject project) {
        Object result = project.getContextValue(PRELIMINARY_TARGET_PLATFORM_KEY);
        if (result instanceof PreliminaryTargetPlatformImpl) {
            return (PreliminaryTargetPlatformImpl)result;
        }
        return null;
    }

    private List<PublishingRepository> getBuildResults(List<? extends ReactorProjectIdentities> projects) {
        ArrayList<PublishingRepository> results = new ArrayList<PublishingRepository>(projects.size());
        for (ReactorProjectIdentities reactorProjectIdentities : projects) {
            results.add(this.getPublishingRepository(reactorProjectIdentities));
        }
        return results;
    }

    public TargetPlatform getFinalTargetPlatform(ReactorProject project) {
        TargetPlatform targetPlatform = (TargetPlatform)project.getContextValue(FINAL_TARGET_PLATFORM_KEY);
        if (targetPlatform == null) {
            throw new IllegalStateException("Target platform is missing");
        }
        return targetPlatform;
    }

    private static File createTempDir(String prefix) throws IOException {
        File tempFile = File.createTempFile(prefix, "");
        tempFile.delete();
        tempFile.mkdirs();
        if (!tempFile.isDirectory()) {
            throw new IOException("Failed to create temporary directory: " + tempFile);
        }
        return tempFile;
    }
}

