/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test.rules.jdk.general;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.ResultProvider;
import org.openjdk.jmc.flightrecorder.rules.ResultToolkit;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.jdk.general.PasswordsInSystemPropertiesRule;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.MockEventCollection;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.TestEvent;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.general.SystemPropertiesTestEvent;

public class PasswordsInSystemPropertiesRuleTest {
    @Test
    public void containsPassword() {
        TestEvent[] testEvents = new TestEvent[]{new SystemPropertiesTestEvent("password")};
        this.testPasswordsInSystemPropertiesRule(testEvents, "The following suspicious system properties were found in this recording: password. The following regular expression was used to exclude strings from this rule: ''(passworld|passwise)''.If you wish to keep having passwords in your system properties, but want to be able to share recordings without also sharing the passwords, please disable the ''Initial System Property'' event.");
    }

    @Test
    public void notContainPassword() {
        TestEvent[] testEvents = new TestEvent[]{new SystemPropertiesTestEvent("paswrd")};
        this.testPasswordsInSystemPropertiesRule(testEvents, "The recording does not seem to contain passwords in the system properties.");
    }

    @Test
    public void containsExcludedStrings() {
        TestEvent[] testEvents = new TestEvent[]{new SystemPropertiesTestEvent("passworld")};
        this.testPasswordsInSystemPropertiesRule(testEvents, "The recording does not seem to contain passwords in the system properties.");
    }

    private void testPasswordsInSystemPropertiesRule(TestEvent[] testEvents, String descriptionExpected) {
        MockEventCollection events = new MockEventCollection(testEvents);
        PasswordsInSystemPropertiesRule passwordsInSystemPropertiesRule = new PasswordsInSystemPropertiesRule();
        RunnableFuture future = passwordsInSystemPropertiesRule.createEvaluation((IItemCollection)events, IPreferenceValueProvider.DEFAULT_VALUES, (IResultValueProvider)new ResultProvider());
        try {
            future.run();
            IResult res = (IResult)future.get();
            String message = res.getSeverity() == Severity.OK ? res.getSummary() : ResultToolkit.populateMessage((IResult)res, (String)res.getExplanation(), (boolean)false) + res.getSolution();
            Assert.assertEquals((Object)descriptionExpected, (Object)message);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }
}

