/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test.rules.jdk;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultProvider;
import org.openjdk.jmc.flightrecorder.rules.ResultToolkit;
import org.openjdk.jmc.flightrecorder.rules.jdk.io.SocketReadRule;
import org.openjdk.jmc.flightrecorder.rules.jdk.io.SocketWriteRule;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.MockEventCollection;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.SocketTestEvent;
import org.openjdk.jmc.flightrecorder.test.rules.jdk.TestEvent;

public class TestSocketReadWriteRule {
    private static final String ADDRESS_1 = "123.45.67.78";
    private static final String ADDRESS_2 = "123.102.103.104";

    @Test
    public void testReadRule() {
        this.testSocketRule("jdk.SocketRead", (IRule)new SocketReadRule(), "The longest recorded socket read took 5\u00a0s to read 4\u00a0KiB from the host at 123.45.67.78. Average time of recorded IO: 4.500\u00a0s. Total time of recorded IO: 13.500\u00a0s. Total time of recorded IO for the host 123.45.67.78: 9.500\u00a0s. Note that there are some socket read patterns with high duration reads that we consider to be normal and are therefore excluded. Such patterns include JMX RMI communication and MQ series.");
    }

    @Test
    public void testWriteRule() {
        this.testSocketRule("jdk.SocketWrite", (IRule)new SocketWriteRule(), "The longest recorded socket write took 5\u00a0s to write 4\u00a0KiB to the host at 123.45.67.78. Average time of recorded IO: 4.500\u00a0s. Total time of recorded IO: 13.500\u00a0s. Total time of recorded IO for the host 123.45.67.78: 9.500\u00a0s. Note that there are some socket write patterns with high duration writes that we consider to be normal and are therefore excluded. Such patterns include JMX RMI communication.");
    }

    private void testSocketRule(String eventType, IRule rule, String expectedLongDesc) {
        TestEvent[] testEvents = new TestEvent[]{new SocketTestEvent(eventType, ADDRESS_1, 4500L, 4096L), new SocketTestEvent(eventType, ADDRESS_1, 5000L, 4096L), new SocketTestEvent(eventType, ADDRESS_2, 4000L, 4096L)};
        MockEventCollection events = new MockEventCollection(testEvents);
        RunnableFuture future = rule.createEvaluation((IItemCollection)events, IPreferenceValueProvider.DEFAULT_VALUES, (IResultValueProvider)new ResultProvider());
        try {
            future.run();
            IResult res = (IResult)future.get();
            String longDesc = ResultToolkit.populateMessage((IResult)res, (String)res.getExplanation(), (boolean)false);
            Assert.assertEquals((Object)expectedLongDesc, (Object)longDesc);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }
}

