/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test.internal.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.internal.util.DisjointBuilder;

public class DisjointBuilderTest {
    private static final IMemberAccessor<IQuantity, RangeObject> START = new IMemberAccessor<IQuantity, RangeObject>(){

        public IQuantity getMember(RangeObject inObject) {
            return inObject.start;
        }
    };
    private static final IMemberAccessor<IQuantity, RangeObject> END = new IMemberAccessor<IQuantity, RangeObject>(){

        public IQuantity getMember(RangeObject inObject) {
            return inObject.end;
        }
    };
    private static final DisjointBuilder.ArrayFactory<RangeObject> ARRAY_FACTORY = new DisjointBuilder.ArrayFactory<RangeObject>(){

        public RangeObject[] createArray(int size) {
            return new RangeObject[size];
        }
    };

    @Test
    public void testInOrderAdd() throws IOException {
        ArrayList<DisjointBuilder> builders = new ArrayList<DisjointBuilder>();
        for (int i = 0; i < 10; ++i) {
            DisjointBuilder builder = new DisjointBuilder(START, END);
            for (int j = 0; j < 10000; ++j) {
                long start = i * 10000 + j;
                builder.add((Object)new RangeObject((IQuantity)UnitLookup.NUMBER_UNITY.quantity(start), (IQuantity)UnitLookup.NUMBER_UNITY.quantity(start + 1L)));
            }
            builders.add(builder);
        }
        Collection arrays = DisjointBuilder.toArrays(builders, ARRAY_FACTORY);
        Iterator iterator = arrays.iterator();
        RangeObject[] array = (RangeObject[])iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((long)100000L, (long)array.length);
        DisjointBuilderTest.checkNoOverlap(array);
    }

    @Test
    public void testRandomAdd() throws IOException {
        for (int i = 0; i < 100; ++i) {
            DisjointBuilderTest.testRandomAdd(i);
        }
    }

    @Test
    public void testEmpty() throws IOException {
        ArrayList<DisjointBuilder> empty = new ArrayList<DisjointBuilder>();
        Assert.assertFalse((boolean)DisjointBuilder.toArrays(empty, ARRAY_FACTORY).iterator().hasNext());
        empty.add(new DisjointBuilder(START, END));
        Assert.assertFalse((boolean)DisjointBuilder.toArrays(empty, ARRAY_FACTORY).iterator().hasNext());
    }

    private static void testRandomAdd(long randomSeed) throws IOException {
        Random rand = new Random(randomSeed);
        ArrayList<DisjointBuilder> builders = new ArrayList<DisjointBuilder>();
        for (int i = 0; i < 10; ++i) {
            DisjointBuilder builder = new DisjointBuilder(START, END);
            for (int j = 0; j < 100; ++j) {
                int start = rand.nextInt(10000000);
                builder.add((Object)new RangeObject((IQuantity)UnitLookup.NUMBER_UNITY.quantity((long)start), (IQuantity)UnitLookup.NUMBER_UNITY.quantity((long)(start + rand.nextInt(10)))));
            }
            builders.add(builder);
        }
        Collection arrays = DisjointBuilder.toArrays(builders, ARRAY_FACTORY);
        for (RangeObject[] array : arrays) {
            DisjointBuilderTest.checkNoOverlap(array);
        }
    }

    private static void checkNoOverlap(RangeObject[] array) throws IOException {
        ITypedQuantity lastEnd = UnitLookup.NUMBER_UNITY.quantity(0L);
        for (RangeObject element : array) {
            if (element.start.compareTo((Object)lastEnd) < 0) {
                Assert.fail((String)("DisjointBuilder must build arrays of non-overlapping ranges: " + element.start.clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY) + " < " + lastEnd.clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY)));
            }
            lastEnd = element.end;
        }
    }

    private static class RangeObject {
        private final IQuantity start;
        private final IQuantity end;

        RangeObject(IQuantity start, IQuantity end) {
            this.start = start;
            this.end = end;
        }
    }
}

