/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.collection.FastAccessNumberMap;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.IParserStats;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.openjdk.jmc.flightrecorder.parser.IConstantPoolExtension;
import org.openjdk.jmc.flightrecorder.parser.IParserExtension;
import org.openjdk.jmc.flightrecorder.parser.ParserExtensionRegistry;

public class ConstantPoolExtensionTest {
    private static final String[] POOL_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "java.lang.Class", "java.lang.String", "java.lang.Thread", "jdk.jfr.BooleanFlag", "jdk.jfr.Category", "jdk.jfr.ContentType", "jdk.jfr.DataAmount", "jdk.jfr.Description", "jdk.jfr.Enabled", "jdk.jfr.Experimental", "jdk.jfr.internal.Cutoff", "jdk.jfr.Label", "jdk.jfr.MemoryAddress", "jdk.jfr.Name", "jdk.jfr.Percentage", "jdk.jfr.Period", "jdk.jfr.Relational", "jdk.jfr.StackTrace", "jdk.jfr.Threshold", "jdk.jfr.Timespan", "jdk.jfr.Timestamp", "jdk.jfr.TransitionFrom", "jdk.jfr.Unsigned", "jdk.settings.Cutoff", "jdk.settings.Enabled", "jdk.settings.Period", "jdk.settings.StackTrace", "jdk.settings.Threshold", "jdk.types.CalleeMethod", "jdk.types.ClassLoader", "jdk.types.CodeBlobType", "jdk.types.CompileId", "jdk.types.CompilerPhaseType", "jdk.types.CopyFailed", "jdk.types.FlagValueOrigin", "jdk.types.FrameType", "jdk.types.G1EvacuationStatistics", "jdk.types.G1HeapRegionType", "jdk.types.G1YCType", "jdk.types.GCCause", "jdk.types.GcId", "jdk.types.GCName", "jdk.types.GCThresholdUpdater", "jdk.types.GCWhen", "jdk.types.InflateCause", "jdk.types.JavaMonitorAddress", "jdk.types.MetadataType", "jdk.types.MetaspaceObjectType", "jdk.types.MetaspaceSizes", "jdk.types.Method", "jdk.types.Module", "jdk.types.NarrowOopMode", "jdk.types.NetworkInterfaceName", "jdk.types.ObjectSpace", "jdk.types.OldObject", "jdk.types.OldObjectArray", "jdk.types.OldObjectField", "jdk.types.OldObjectGcRoot", "jdk.types.OldObjectRootSystem", "jdk.types.OldObjectRootType", "jdk.types.Package", "jdk.types.Reference", "jdk.types.ReferenceType", "jdk.types.SafepointId", "jdk.types.StackFrame", "jdk.types.StackTrace", "jdk.types.SweepId", "jdk.types.Symbol", "jdk.types.ThreadGroup", "jdk.types.ThreadState", "jdk.types.VirtualSpace", "jdk.types.VMOperationType", "jdk.types.ZStatisticsCounterType", "jdk.types.ZStatisticsSamplerType", "long", "short"};
    private static final int[] POOL_SIZES = new int[]{0, 0, 0, 0, 0, 0, 504, 0, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 126, 5, 0, 29, 0, 8, 4, 0, 8, 4, 32, 0, 12, 2, 2, 7, 0, 2, 14, 0, 1280, 65, 4, 4, 0, 1, 0, 0, 0, 12, 5, 656, 0, 6, 0, 0, 211, 0, 3485, 5, 9, 0, 76, 0, 0, 0, 0};
    private static final String[] READ_EVENT_TYPES = new String[]{"java.lang.Class", "java.lang.Thread", "jdk.types.ClassLoader", "jdk.types.CodeBlobType", "jdk.types.CompilerPhaseType", "jdk.types.FlagValueOrigin", "jdk.types.FrameType", "jdk.types.G1HeapRegionType", "jdk.types.G1YCType", "jdk.types.GCCause", "jdk.types.GCName", "jdk.types.GCThresholdUpdater", "jdk.types.GCWhen", "jdk.types.InflateCause", "jdk.types.MetadataType", "jdk.types.MetaspaceObjectType", "jdk.types.Method", "jdk.types.Module", "jdk.types.NarrowOopMode", "jdk.types.NetworkInterfaceName", "jdk.types.OldObject", "jdk.types.OldObjectRootSystem", "jdk.types.OldObjectRootType", "jdk.types.Package", "jdk.types.ReferenceType", "jdk.types.StackTrace", "jdk.types.Symbol", "jdk.types.ThreadGroup", "jdk.types.ThreadState", "jdk.types.VMOperationType"};
    private static final String[] REF_EVENT_TYPES = new String[]{"java.lang.Class", "java.lang.Thread", "jdk.ActiveRecording", "jdk.ActiveSetting", "jdk.BiasedLockRevocation", "jdk.BiasedLockSelfRevocation", "jdk.BooleanFlag", "jdk.ClassDefine", "jdk.ClassLoad", "jdk.ClassLoaderStatistics", "jdk.CodeCacheStatistics", "jdk.Compilation", "jdk.CompilerInlining", "jdk.DoubleFlag", "jdk.ExceptionStatistics", "jdk.ExecuteVMOperation", "jdk.ExecutionSample", "jdk.Flush", "jdk.G1GarbageCollection", "jdk.G1HeapSummary", "jdk.GarbageCollection", "jdk.GCConfiguration", "jdk.GCHeapConfiguration", "jdk.GCHeapSummary", "jdk.GCPhaseParallel", "jdk.GCPhasePause", "jdk.GCPhasePauseLevel1", "jdk.GCPhasePauseLevel2", "jdk.GCReferenceStatistics", "jdk.IntFlag", "jdk.JavaMonitorWait", "jdk.LongFlag", "jdk.MetaspaceChunkFreeListSummary", "jdk.MetaspaceSummary", "jdk.ModuleExport", "jdk.ModuleRequire", "jdk.NativeMethodSample", "jdk.NetworkUtilization", "jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB", "jdk.OldObjectSample", "jdk.PromoteObjectInNewPLAB", "jdk.PromoteObjectOutsidePLAB", "jdk.SafepointBegin", "jdk.SocketRead", "jdk.StringFlag", "jdk.ThreadAllocationStatistics", "jdk.ThreadCPULoad", "jdk.ThreadEnd", "jdk.ThreadStart", "jdk.types.ClassLoader", "jdk.types.Method", "jdk.types.Module", "jdk.types.OldObject", "jdk.types.Package", "jdk.types.StackFrame", "jdk.types.ThreadGroup", "jdk.UnsignedIntFlag", "jdk.UnsignedLongFlag", "WorkEvent"};
    private static final String[] RESOLVED_EVENT_TYPES = new String[]{"jdk.types.Method", "jdk.types.Module", "java.lang.Thread", "jdk.types.StackFrame", "jdk.types.ClassLoader", "jdk.types.ThreadGroup", "java.lang.Class", "jdk.types.Package", "jdk.types.OldObject"};

    @Test
    public void constantResolution() throws IOException, CouldNotLoadRecordingException {
        ArrayList<MyParserExtension> extensions = new ArrayList<MyParserExtension>(ParserExtensionRegistry.getParserExtensions());
        extensions.add(new MyParserExtension());
        File recordingFile = new File(ConstantPoolExtensionTest.class.getClassLoader().getResource("recordings/metadata_new.jfr").getFile());
        IItemCollection items = JfrLoaderToolkit.loadEvents(Arrays.asList(recordingFile), extensions);
        Assert.assertTrue((boolean)items.hasItems());
        IConstantPoolExtension ext = (IConstantPoolExtension)((IParserStats)items).getConstantPoolExtensions().get(MyConstantPoolExtension.class.getSimpleName());
        Assert.assertNotNull((Object)ext);
        MyConstantPoolExtension extension = (MyConstantPoolExtension)ext;
        for (String eventType : READ_EVENT_TYPES) {
            Assert.assertTrue((boolean)extension.readEventTypes.contains(eventType));
        }
        for (String eventType : REF_EVENT_TYPES) {
            Assert.assertTrue((boolean)extension.referencedEventTypes.contains(eventType));
        }
        for (String eventType : RESOLVED_EVENT_TYPES) {
            Assert.assertTrue((boolean)extension.resolvedEventTypes.contains(eventType));
        }
    }

    private static class MyConstantPoolExtension
    implements IConstantPoolExtension {
        Set<String> readEventTypes = new HashSet<String>();
        Set<String> referencedEventTypes = new HashSet<String>();
        Set<String> resolvedEventTypes = new HashSet<String>();
        private FastAccessNumberMap<Object> constantPool;

        private MyConstantPoolExtension() {
        }

        public Object constantRead(long constantIndex, Object constant, String eventTypeId) {
            this.readEventTypes.add(eventTypeId);
            return constant;
        }

        public Object constantReferenced(Object constant, String poolName, String eventTypeId) {
            this.referencedEventTypes.add(eventTypeId);
            return constant;
        }

        public Object constantResolved(Object constant, String poolName, String eventTypeId) {
            this.resolvedEventTypes.add(eventTypeId);
            return constant;
        }

        public void allConstantPoolsResolved(Map<String, FastAccessNumberMap<Object>> constantPools) {
            for (int i = 0; i < POOL_NAMES.length; ++i) {
                this.constantPool = constantPools.get(POOL_NAMES[i]);
                Assert.assertNotNull(this.constantPool);
                int count = 0;
                Iterator it = this.constantPool.iterator();
                while (it.hasNext()) {
                    it.next();
                    ++count;
                }
                Assert.assertEquals((long)POOL_SIZES[i], (long)count);
            }
        }
    }

    private class MyParserExtension
    implements IParserExtension {
        private MyParserExtension() {
        }

        public IConstantPoolExtension createConstantPoolExtension() {
            return new MyConstantPoolExtension();
        }
    }
}

