/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueBuilderImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Annotation;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.TypedFieldBuilder;
import org.openjdk.jmc.flightrecorder.writer.api.TypedValueBuilder;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

final class TypedFieldBuilderImpl
implements TypedFieldBuilder {
    private final TypesImpl types;
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final TypeImpl type;
    private final String name;
    private boolean asArray;

    TypedFieldBuilderImpl(String name, TypeImpl type, TypesImpl types) {
        this.type = type;
        this.name = name;
        this.types = types;
    }

    @Override
    public TypedFieldBuilderImpl addAnnotation(Type type) {
        return this.addAnnotation(type, (String)null);
    }

    @Override
    public TypedFieldBuilderImpl addAnnotation(Type type, String value) {
        this.annotations.add(new Annotation(type, value));
        return this;
    }

    @Override
    public TypedFieldBuilderImpl addAnnotation(Types.Predefined type) {
        return this.addAnnotation(this.types.getType(type));
    }

    @Override
    public TypedFieldBuilderImpl addAnnotation(Types.Predefined type, String value) {
        return this.addAnnotation((Type)this.types.getType(type), value);
    }

    @Override
    public TypedFieldBuilder addAnnotation(Type type, Consumer<TypedValueBuilder> builderCallback) {
        TypedValueBuilderImpl impl = new TypedValueBuilderImpl((TypeImpl)type);
        if (builderCallback != null) {
            builderCallback.accept(impl);
        }
        this.annotations.add(new Annotation(type, impl.build(), new Annotation[0]));
        return this;
    }

    @Override
    public TypedFieldBuilder addAnnotation(Types.Predefined type, Consumer<TypedValueBuilder> builderCallback) {
        return this.addAnnotation((Type)this.types.getType(type), (Consumer)builderCallback);
    }

    @Override
    public TypedFieldBuilderImpl asArray() {
        this.asArray = true;
        return this;
    }

    @Override
    public TypedFieldImpl build() {
        return new TypedFieldImpl(this.type, this.name, this.asArray, this.annotations);
    }
}

