/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.openjdk.jmc.flightrecorder.writer.SelfType;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeStructureImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldBuilderImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueBuilderImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Annotation;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.TypeStructure;
import org.openjdk.jmc.flightrecorder.writer.api.TypeStructureBuilder;
import org.openjdk.jmc.flightrecorder.writer.api.TypedField;
import org.openjdk.jmc.flightrecorder.writer.api.TypedFieldBuilder;
import org.openjdk.jmc.flightrecorder.writer.api.TypedValueBuilder;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

final class TypeStructureBuilderImpl
implements TypeStructureBuilder {
    private final TypesImpl types;
    private final List<TypedFieldImpl> fieldList = new ArrayList<TypedFieldImpl>();
    private final List<Annotation> annotations = new ArrayList<Annotation>();

    TypeStructureBuilderImpl(TypesImpl types) {
        this.types = types;
    }

    @Override
    public TypeStructureBuilderImpl addField(String name, Types.Predefined type) {
        return this.addField(name, type, (Consumer)null);
    }

    @Override
    public TypeStructureBuilderImpl addField(String name, Types.Predefined type, Consumer<TypedFieldBuilder> fieldCallback) {
        return this.addField(name, (Type)this.types.getType(type), (Consumer)fieldCallback);
    }

    @Override
    public TypeStructureBuilderImpl addField(String name, Type type) {
        return this.addField(name, type, (Consumer)null);
    }

    @Override
    public TypeStructureBuilderImpl addField(String name, Type type, Consumer<TypedFieldBuilder> fieldCallback) {
        TypedFieldBuilderImpl annotationsBuilder = new TypedFieldBuilderImpl(name, (TypeImpl)type, this.types);
        if (fieldCallback != null) {
            fieldCallback.accept(annotationsBuilder);
        }
        this.fieldList.add(annotationsBuilder.build());
        return this;
    }

    @Override
    public TypeStructureBuilder addField(TypedField field) {
        this.fieldList.add((TypedFieldImpl)field);
        return this;
    }

    @Override
    public TypeStructureBuilder addFields(TypedField field1, TypedField field2, TypedField ... fields) {
        this.fieldList.add((TypedFieldImpl)field1);
        this.fieldList.add((TypedFieldImpl)field2);
        for (TypedField field : fields) {
            this.fieldList.add((TypedFieldImpl)field);
        }
        return this;
    }

    @Override
    public TypeStructureBuilderImpl addAnnotation(Type type) {
        return this.addAnnotation(type, (String)null);
    }

    @Override
    public TypeStructureBuilderImpl addAnnotation(Type type, String value) {
        this.annotations.add(new Annotation(type, value));
        return this;
    }

    @Override
    public TypeStructureBuilderImpl addAnnotation(Types.Predefined type) {
        return this.addAnnotation(this.types.getType(type));
    }

    @Override
    public TypeStructureBuilderImpl addAnnotation(Types.Predefined type, String value) {
        return this.addAnnotation((Type)this.types.getType(type), value);
    }

    @Override
    public TypeStructureBuilderImpl addAnnotation(Type type, Consumer<TypedValueBuilder> builderCallback) {
        TypedValueBuilderImpl impl = new TypedValueBuilderImpl((TypeImpl)type);
        if (builderCallback != null) {
            builderCallback.accept(impl);
        }
        this.annotations.add(new Annotation(type, impl.build(), new Annotation[0]));
        return this;
    }

    @Override
    public TypeStructureBuilderImpl addAnnotation(Types.Predefined type, Consumer<TypedValueBuilder> builderCallback) {
        return this.addAnnotation((Type)this.types.getType(type), (Consumer)builderCallback);
    }

    @Override
    public Type selfType() {
        return SelfType.INSTANCE;
    }

    @Override
    public TypeStructure build() {
        return new TypeStructureImpl(this.fieldList, this.annotations);
    }

    @Override
    public Type registerAs(String name, String supertype) {
        return this.types.getOrAdd(name, supertype, this.build());
    }
}

