/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.openjdk.jmc.flightrecorder.writer.LEB128ByteArrayWriter;

public interface LEB128Writer {
    public static final int EXT_BIT = 128;
    public static final long COMPRESSED_INT_MASK = -128L;

    public static LEB128Writer getInstance() {
        return new LEB128ByteArrayWriter(Short.MAX_VALUE);
    }

    public void reset();

    public LEB128Writer writeChar(char var1);

    public long writeChar(long var1, char var3);

    public LEB128Writer writeShort(short var1);

    public long writeShort(long var1, short var3);

    public LEB128Writer writeInt(int var1);

    public long writeInt(long var1, int var3);

    public LEB128Writer writeLong(long var1);

    public long writeLong(long var1, long var3);

    public LEB128Writer writeFloat(float var1);

    public long writeFloat(long var1, float var3);

    public LEB128Writer writeDouble(double var1);

    public long writeDouble(long var1, double var3);

    public LEB128Writer writeBoolean(boolean var1);

    public long writeBoolean(long var1, boolean var3);

    public LEB128Writer writeByte(byte var1);

    public long writeByte(long var1, byte var3);

    public LEB128Writer writeBytes(byte ... var1);

    public long writeBytes(long var1, byte ... var3);

    public LEB128Writer writeUTF(String var1);

    public LEB128Writer writeUTF(byte[] var1);

    public long writeUTF(long var1, String var3);

    public long writeUTF(long var1, byte[] var3);

    public LEB128Writer writeCompactUTF(byte[] var1);

    public long writeCompactUTF(long var1, byte[] var3);

    public LEB128Writer writeCompactUTF(String var1);

    public long writeCompactUTF(long var1, String var3);

    public LEB128Writer writeShortRaw(short var1);

    public long writeShortRaw(long var1, short var3);

    public LEB128Writer writeIntRaw(int var1);

    public long writeIntRaw(long var1, int var3);

    public LEB128Writer writeLongRaw(long var1);

    public long writeLongRaw(long var1, long var3);

    default public byte[] export() {
        byte[][] dataRef = new byte[1][];
        this.export(buffer -> {
            int limit = buffer.limit();
            buffer.flip();
            int len = buffer.remaining();
            if (buffer.hasArray()) {
                dataRef[0] = new byte[len];
                System.arraycopy(buffer.array(), buffer.arrayOffset() + buffer.position(), dataRef[0], 0, len);
                buffer.position(buffer.limit());
            } else {
                dataRef[0] = new byte[len];
                buffer.get(dataRef[0]);
            }
            buffer.limit(limit);
        });
        return dataRef[0];
    }

    public void export(Consumer<ByteBuffer> var1);

    public int position();

    public int length();

    public int capacity();
}

