/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.nio.charset.StandardCharsets;
import org.openjdk.jmc.flightrecorder.writer.LEB128Writer;

abstract class AbstractLEB128Writer
implements LEB128Writer {
    AbstractLEB128Writer() {
    }

    @Override
    public final LEB128Writer writeChar(char data) {
        this.writeChar(this.position(), data);
        return this;
    }

    @Override
    public final long writeChar(long offset, char data) {
        return this.writeLong(offset, (long)data & 0xFFFFL);
    }

    @Override
    public final LEB128Writer writeShort(short data) {
        this.writeShort(this.position(), data);
        return this;
    }

    @Override
    public final long writeShort(long offset, short data) {
        return this.writeLong(offset, (long)data & 0xFFFFL);
    }

    @Override
    public final LEB128Writer writeInt(int data) {
        this.writeInt(this.position(), data);
        return this;
    }

    @Override
    public final long writeInt(long offset, int data) {
        return this.writeLong(offset, (long)data & 0xFFFFFFFFL);
    }

    @Override
    public final LEB128Writer writeLong(long data) {
        this.writeLong(this.position(), data);
        return this;
    }

    @Override
    public final long writeLong(long offset, long data) {
        if ((data & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return this.writeByte(offset, (byte)(data & 0xFFL));
        }
        offset = this.writeByte(offset, (byte)(data | 0x80L));
        if (((data >>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return this.writeByte(offset, (byte)data);
        }
        offset = this.writeByte(offset, (byte)(data | 0x80L));
        if (((data >>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return this.writeByte(offset, (byte)data);
        }
        offset = this.writeByte(offset, (byte)(data | 0x80L));
        if (((data >>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return this.writeByte(offset, (byte)data);
        }
        offset = this.writeByte(offset, (byte)(data | 0x80L));
        if (((data >>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return this.writeByte(offset, (byte)data);
        }
        offset = this.writeByte(offset, (byte)(data | 0x80L));
        if (((data >>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return this.writeByte(offset, (byte)data);
        }
        offset = this.writeByte(offset, (byte)(data | 0x80L));
        if (((data >>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return this.writeByte(offset, (byte)data);
        }
        offset = this.writeByte(offset, (byte)(data | 0x80L));
        if (((data >>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return this.writeByte(offset, (byte)data);
        }
        offset = this.writeByte(offset, (byte)(data | 0x80L));
        return this.writeByte(offset, (byte)(data >> 7));
    }

    @Override
    public final LEB128Writer writeFloat(float data) {
        this.writeFloat(this.position(), data);
        return this;
    }

    @Override
    public final LEB128Writer writeDouble(double data) {
        this.writeDouble(this.position(), data);
        return this;
    }

    @Override
    public final LEB128Writer writeBoolean(boolean data) {
        this.writeBoolean(this.position(), data);
        return this;
    }

    @Override
    public final long writeBoolean(long offset, boolean data) {
        return this.writeByte(offset, data ? (byte)1 : 0);
    }

    @Override
    public final LEB128Writer writeByte(byte data) {
        this.writeByte(this.position(), data);
        return this;
    }

    @Override
    public final LEB128Writer writeBytes(byte ... data) {
        this.writeBytes(this.position(), data);
        return this;
    }

    @Override
    public final LEB128Writer writeUTF(String data) {
        this.writeUTF((long)this.position(), data);
        return this;
    }

    @Override
    public final LEB128Writer writeUTF(byte[] data) {
        this.writeUTF((long)this.position(), data);
        return this;
    }

    @Override
    public final long writeUTF(long offset, String data) {
        return this.writeUTF(offset, data == null ? null : data.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public final long writeUTF(long offset, byte[] data) {
        int len = data == null ? 0 : data.length;
        long pos = this.writeInt(offset, len);
        if (len > 0) {
            pos = this.writeBytes(pos, data);
        }
        return pos;
    }

    @Override
    public final LEB128Writer writeCompactUTF(byte[] data) {
        this.writeCompactUTF((long)this.position(), data);
        return this;
    }

    @Override
    public final LEB128Writer writeCompactUTF(String data) {
        this.writeCompactUTF((long)this.position(), data);
        return this;
    }

    @Override
    public final long writeCompactUTF(long offset, byte[] data) {
        if (data == null) {
            return this.writeByte(offset, (byte)0);
        }
        if (data.length == 0) {
            return this.writeByte(offset, (byte)1);
        }
        long pos = this.writeByte(offset, (byte)3);
        pos = this.writeInt(pos, data.length);
        pos = this.writeBytes(pos, data);
        return pos;
    }

    @Override
    public final long writeCompactUTF(long offset, String data) {
        return this.writeCompactUTF(offset, data != null ? data.getBytes(StandardCharsets.UTF_8) : null);
    }

    @Override
    public final LEB128Writer writeShortRaw(short data) {
        this.writeShortRaw(this.position(), data);
        return this;
    }

    @Override
    public final LEB128Writer writeIntRaw(int data) {
        this.writeIntRaw(this.position(), data);
        return this;
    }

    @Override
    public final LEB128Writer writeLongRaw(long data) {
        this.writeLongRaw(this.position(), data);
        return this;
    }

    @Override
    public final int length() {
        return AbstractLEB128Writer.adjustLength(this.position());
    }

    static int adjustLength(int length) {
        int extraLen = 0;
        while (AbstractLEB128Writer.getPackedIntLen(length + (extraLen = AbstractLEB128Writer.getPackedIntLen(length + extraLen))) != extraLen) {
        }
        return length + extraLen;
    }

    static int getPackedIntLen(long data) {
        if ((data & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (((data >>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 2;
        }
        if (((data >>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 3;
        }
        if (((data >>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 4;
        }
        if (((data >>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 5;
        }
        if (((data >>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 6;
        }
        if (((data >>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 7;
        }
        if (((data >>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 8;
        }
        return 9;
    }
}

