/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.p2base.artifact.repository;

import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.AbstractArtifactRepository;
import org.eclipse.osgi.util.NLS;

public class ListCompositeArtifactRepository
extends AbstractArtifactRepository
implements ICompositeRepository<IArtifactKey>,
IArtifactRepository,
IFileArtifactRepository {
    private List<? extends IArtifactRepository> artifactRepositories;

    public ListCompositeArtifactRepository(IProvisioningAgent agent, List<? extends IArtifactRepository> artifactRepositories) {
        super(agent, null, "org.eclipse.equinox.p2.artifact.repository.compositeRepository", null, null, null, null, null);
        try {
            this.setLocation(new URI("list:" + UUID.randomUUID()));
        }
        catch (URISyntaxException e) {
            throw new AssertionError("should never happen", e);
        }
        this.artifactRepositories = artifactRepositories;
    }

    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        int size = this.artifactRepositories.size();
        if (size == 1) {
            return this.artifactRepositories.get(0).query(query, monitor);
        }
        Collector collector = new Collector();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)size);
        for (IArtifactRepository iArtifactRepository : this.artifactRepositories) {
            collector.addAll(iArtifactRepository.query(query, (IProgressMonitor)subMonitor.split(1)));
        }
        return collector;
    }

    public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        int size = this.artifactRepositories.size();
        if (size == 1) {
            return this.artifactRepositories.get(0).getRawArtifact(descriptor, destination, monitor);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        int i = 0;
        while (i < size) {
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            IArtifactRepository artifactRepository = this.artifactRepositories.get(i);
            if (artifactRepository.contains(descriptor)) {
                return artifactRepository.getRawArtifact(descriptor, destination, (IProgressMonitor)subMonitor);
            }
            ++i;
        }
        return new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.artifact_not_found, (Object)descriptor));
    }

    public IQueryable<IArtifactDescriptor> descriptorQueryable() {
        if (this.artifactRepositories.size() == 1) {
            return this.artifactRepositories.get(0).descriptorQueryable();
        }
        return (query, monitor) -> {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.artifactRepositories.size());
            Collector collector = new Collector();
            for (IArtifactRepository iArtifactRepository : this.artifactRepositories) {
                collector.addAll(iArtifactRepository.descriptorQueryable().query(query, (IProgressMonitor)subMonitor.split(1)));
            }
            return collector;
        };
    }

    public void addChild(URI child) {
        throw new UnsupportedOperationException();
    }

    public List<URI> getChildren() {
        ArrayList<URI> list = new ArrayList<URI>();
        for (IArtifactRepository iArtifactRepository : this.artifactRepositories) {
            list.add(iArtifactRepository.getLocation());
        }
        return list;
    }

    public void removeAllChildren() {
        throw new UnsupportedOperationException();
    }

    public void removeChild(URI child) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(IArtifactDescriptor descriptor) {
        for (IArtifactRepository iArtifactRepository : this.artifactRepositories) {
            if (!iArtifactRepository.contains(descriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IArtifactKey key) {
        for (IArtifactRepository iArtifactRepository : this.artifactRepositories) {
            if (!iArtifactRepository.contains(key)) continue;
            return true;
        }
        return false;
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        for (IArtifactRepository iArtifactRepository : this.artifactRepositories) {
            if (!iArtifactRepository.contains(descriptor)) continue;
            return iArtifactRepository.getArtifact(descriptor, destination, monitor);
        }
        return new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.artifact_not_found, (Object)descriptor));
    }

    public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        ArrayList<IArtifactDescriptor> result = new ArrayList<IArtifactDescriptor>();
        for (IArtifactRepository iArtifactRepository : this.artifactRepositories) {
            if (!iArtifactRepository.contains(key)) continue;
            IArtifactDescriptor[] tempResult = iArtifactRepository.getArtifactDescriptors(key);
            result.addAll(Arrays.asList(tempResult));
        }
        return result.toArray(new IArtifactDescriptor[result.size()]);
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        int size = this.artifactRepositories.size();
        if (size == 1) {
            return this.artifactRepositories.get(0).getArtifacts(requests, monitor);
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.equinox.p2.artifact.repository", 0, Messages.message_artifactsFromChildRepos, null);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(requests.length * size));
        int i = 0;
        while (i < requests.length) {
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            IArtifactRequest request = requests[i];
            subMonitor.setWorkRemaining((requests.length - i) * size);
            IArtifactDescriptor[] descriptors = this.getArtifactDescriptors(request.getArtifactKey());
            if (descriptors.length > 0 && descriptors[0].getRepository() != null) {
                multiStatus.add(descriptors[0].getRepository().getArtifacts(new IArtifactRequest[]{request}, (IProgressMonitor)subMonitor.split(1)));
            } else {
                for (IArtifactRepository iArtifactRepository : this.artifactRepositories) {
                    if (!iArtifactRepository.contains(request.getArtifactKey())) continue;
                    IStatus status = iArtifactRepository.getArtifacts(new IArtifactRequest[]{request}, (IProgressMonitor)subMonitor.split(1));
                    multiStatus.add(status);
                    if (status.getSeverity() == 8) {
                        return multiStatus;
                    }
                    if (!status.isOK()) continue;
                    return status;
                }
            }
            ++i;
        }
        return multiStatus;
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
        throw new UnsupportedOperationException();
    }

    public File getArtifactFile(IArtifactKey key) {
        return this.getFileFromRepositories(key, IArtifactRepository::contains, IFileArtifactRepository::getArtifactFile);
    }

    public File getArtifactFile(IArtifactDescriptor descriptor) {
        return this.getFileFromRepositories(descriptor, IArtifactRepository::contains, IFileArtifactRepository::getArtifactFile);
    }

    private <X> File getFileFromRepositories(X id, BiPredicate<IFileArtifactRepository, X> when, BiFunction<IFileArtifactRepository, X, File> function) {
        return this.artifactRepositories.stream().filter(IFileArtifactRepository.class::isInstance).map(IFileArtifactRepository.class::cast).filter(r -> when.test((IFileArtifactRepository)r, id)).map(r -> (File)function.apply((IFileArtifactRepository)r, id)).filter(f -> f != null).findFirst().orElse(null);
    }
}

