/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.p2base.artifact.repository;

import java.io.File;
import java.net.URI;
import java.util.List;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactFileProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.formats.ArtifactTransferPolicy;
import org.eclipse.tycho.repository.p2base.artifact.repository.ArtifactRepositorySupplier;
import org.eclipse.tycho.repository.p2base.artifact.repository.RepositoryArtifactProvider;

public class FileRepositoryArtifactProvider
extends RepositoryArtifactProvider
implements IRawArtifactFileProvider {
    public FileRepositoryArtifactProvider(List<IFileArtifactRepository> repositories, ArtifactTransferPolicy transferPolicy) {
        super(repositories, transferPolicy);
    }

    public FileRepositoryArtifactProvider(List<URI> artifactRepositories, ArtifactTransferPolicy transferPolicy, IProvisioningAgent agent) {
        super(artifactRepositories, transferPolicy, agent);
    }

    FileRepositoryArtifactProvider(ArtifactRepositorySupplier repositoryLoader, ArtifactTransferPolicy transferPolicy) {
        super(repositoryLoader, transferPolicy);
    }

    @Override
    protected void repositoriesLoaded() {
        IArtifactRepository[] iArtifactRepositoryArray = this.repositories;
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactRepository repository = iArtifactRepositoryArray[n2];
            if (!(repository instanceof IFileArtifactRepository)) {
                throw new IllegalArgumentException("Repository loaded from \"" + repository.getLocation() + "\" is not a file system based artifact repository.");
            }
            ++n2;
        }
    }

    @Override
    public File getArtifactFile(IArtifactKey key) {
        this.init();
        IArtifactRepository[] iArtifactRepositoryArray = this.repositories;
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactRepository repository = iArtifactRepositoryArray[n2];
            if (repository.contains(key)) {
                return ((IFileArtifactRepository)repository).getArtifactFile(key);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public File getArtifactFile(IArtifactDescriptor descriptor) {
        this.init();
        IArtifactRepository[] iArtifactRepositoryArray = this.repositories;
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactRepository repository = iArtifactRepositoryArray[n2];
            if (repository.contains(descriptor)) {
                return ((IFileArtifactRepository)repository).getArtifactFile(descriptor);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean isFileAlreadyAvailable(IArtifactKey artifactKey) {
        return this.contains(artifactKey);
    }
}

