/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.p2base.artifact.repository;

import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.function.BiFunction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.AbstractArtifactRepository;

public class LazyArtifactRepository
extends AbstractArtifactRepository
implements IFileArtifactRepository {
    private BiFunction<URI, IProvisioningAgent, IArtifactRepository> loader;
    private IArtifactRepository delegate;

    public LazyArtifactRepository(IProvisioningAgent agent, URI uri, BiFunction<URI, IProvisioningAgent, IArtifactRepository> loader) {
        super(agent, "LazyArtifactRepository(" + uri + ")", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null, uri, null, null, null);
        this.loader = loader;
    }

    private synchronized IArtifactRepository getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.loader.apply(this.getLocation(), this.getProvisioningAgent());
            if (this.delegate == null) {
                throw new RuntimeException("lazy loading repository from location " + this.getLocation() + " failed");
            }
            this.setName(this.delegate.getName());
            this.setDescription(this.delegate.getDescription());
            this.setVersion(this.delegate.getVersion());
            this.setProperties(this.delegate.getProperties());
            this.setProvider(this.delegate.getProvider());
            this.setType(this.delegate.getType());
            this.setVersion(this.delegate.getVersion());
        }
        return this.delegate;
    }

    public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        return this.getDelegate().getRawArtifact(descriptor, destination, monitor);
    }

    public IQueryable<IArtifactDescriptor> descriptorQueryable() {
        return this.getDelegate().descriptorQueryable();
    }

    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        return this.getDelegate().query(query, monitor);
    }

    public boolean contains(IArtifactDescriptor descriptor) {
        return this.getDelegate().contains(descriptor);
    }

    public boolean contains(IArtifactKey key) {
        return this.getDelegate().contains(key);
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        return this.getDelegate().getArtifact(descriptor, destination, monitor);
    }

    public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        return this.getDelegate().getArtifactDescriptors(key);
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        return this.getDelegate().getArtifacts(requests, monitor);
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
        return this.getDelegate().getOutputStream(descriptor);
    }

    public File getArtifactFile(IArtifactKey key) {
        IArtifactRepository repository = this.getDelegate();
        if (repository instanceof IFileArtifactRepository) {
            return ((IFileArtifactRepository)repository).getArtifactFile(key);
        }
        return null;
    }

    public File getArtifactFile(IArtifactDescriptor descriptor) {
        IArtifactRepository repository = this.getDelegate();
        if (repository instanceof IFileArtifactRepository) {
            return ((IFileArtifactRepository)repository).getArtifactFile(descriptor);
        }
        return null;
    }
}

