/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.image.awt;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.jemmy.JemmyException;

public class PNGDecoder {
    InputStream in;

    public PNGDecoder(InputStream in) {
        this.in = in;
    }

    byte read() throws IOException {
        byte b = (byte)this.in.read();
        return b;
    }

    int readInt() throws IOException {
        byte[] b = this.read(4);
        return ((b[0] & 0xFF) << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }

    byte[] read(int count) throws IOException {
        byte[] result = new byte[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.read();
        }
        return result;
    }

    boolean compare(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    void checkEquality(byte[] b1, byte[] b2) {
        if (!this.compare(b1, b2)) {
            throw new JemmyException("Format error");
        }
    }

    public BufferedImage decode() throws IOException {
        return this.decode(true);
    }

    public BufferedImage decode(boolean closeStream) throws IOException {
        int mode;
        byte[] id = this.read(12);
        this.checkEquality(id, new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13});
        byte[] ihdr = this.read(4);
        this.checkEquality(ihdr, "IHDR".getBytes());
        int width = this.readInt();
        int height = this.readInt();
        BufferedImage result = new BufferedImage(width, height, 1);
        byte[] head = this.read(5);
        if (this.compare(head, new byte[]{1, 0, 0, 0, 0})) {
            mode = 0;
        } else if (this.compare(head, new byte[]{8, 0, 0, 0, 0})) {
            mode = 1;
        } else if (this.compare(head, new byte[]{8, 2, 0, 0, 0})) {
            mode = 2;
        } else {
            throw new JemmyException("Format error");
        }
        this.readInt();
        int size = this.readInt();
        byte[] idat = this.read(4);
        this.checkEquality(idat, "IDAT".getBytes());
        byte[] data = this.read(size);
        Inflater inflater = new Inflater();
        inflater.setInput(data, 0, size);
        try {
            switch (mode) {
                case 0: {
                    int bytes = width / 8;
                    if (width % 8 != 0) {
                        ++bytes;
                    }
                    byte[] row = new byte[bytes];
                    for (int y = 0; y < height; ++y) {
                        inflater.inflate(new byte[1]);
                        inflater.inflate(row);
                        for (int x = 0; x < bytes; ++x) {
                            byte colorset = row[x];
                            for (int sh = 0; sh < 8 && x * 8 + sh < width; ++sh) {
                                if ((colorset & 0x80) == 128) {
                                    result.setRGB(x * 8 + sh, y, Color.white.getRGB());
                                } else {
                                    result.setRGB(x * 8 + sh, y, Color.black.getRGB());
                                }
                                colorset = (byte)(colorset << 1);
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    byte[] row = new byte[width];
                    for (int y = 0; y < height; ++y) {
                        inflater.inflate(new byte[1]);
                        inflater.inflate(row);
                        for (int x = 0; x < width; ++x) {
                            byte color = row[x];
                            result.setRGB(x, y, (color << 16) + (color << 8) + color);
                        }
                    }
                    break;
                }
                case 2: {
                    byte[] row = new byte[width * 3];
                    for (int y = 0; y < height; ++y) {
                        inflater.inflate(new byte[1]);
                        inflater.inflate(row);
                        for (int x = 0; x < width; ++x) {
                            result.setRGB(x, y, ((row[x * 3 + 0] & 0xFF) << 16) + ((row[x * 3 + 1] & 0xFF) << 8) + (row[x * 3 + 2] & 0xFF));
                        }
                    }
                    break;
                }
            }
        }
        catch (DataFormatException e) {
            throw new JemmyException("ZIP error", (Throwable)e);
        }
        this.readInt();
        this.readInt();
        byte[] iend = this.read(4);
        this.checkEquality(iend, "IEND".getBytes());
        this.readInt();
        if (closeStream) {
            this.in.close();
        }
        return result;
    }

    public static BufferedImage decode(String fileName) {
        try {
            return new PNGDecoder(new FileInputStream(fileName)).decode();
        }
        catch (IOException e) {
            throw new JemmyException("IOException during image reading", (Throwable)e);
        }
    }

    public static BufferedImage decode(InputStream inputStream, boolean closeStream) {
        try {
            return new PNGDecoder(inputStream).decode(closeStream);
        }
        catch (IOException e) {
            throw new JemmyException("IOException during image reading", (Throwable)e);
        }
    }

    public static BufferedImage decode(ClassLoader loader, String resource) {
        try {
            InputStream resourceStream = loader.getResourceAsStream(resource);
            if (resourceStream == null) {
                throw new JemmyException("Resouce '" + resource + "' could not be found!");
            }
            return new PNGDecoder(resourceStream).decode();
        }
        catch (IOException e) {
            throw new JemmyException("IOException during image reading", (Throwable)e);
        }
    }
}

