/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.dev;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.core.osgitools.targetplatform.ArtifactCollection;
import org.eclipse.tycho.dev.DevBundleInfo;

@Component(role=DevWorkspaceResolver.class)
public class DevWorkspaceResolver
implements Initializable {
    private static final String SUFFIX_BASEDIR = ":basedir";
    private static final String SUFFIX_LOCATION = ":location";
    private static final String SUFFIX_ENTRIES = ":entries";
    private static final String SYSPROP_STATELOCATION = "tychodev.workspace.state";
    private static final String FILE_WORKSPACESTATE = "workspacestate.properties";
    @Requirement
    private RepositorySystem repositorySystem;
    private File stateLocation;
    private ArtifactCollection workspaceBundles;
    private Map<File, String> workspaceDeventries;
    private Map<File, File> workspaceBasedirs;

    public void initialize() throws InitializationException {
        HashMap<File, String> workspaceDeventries = new HashMap<File, String>();
        HashMap<File, File> workspaceBasedirs = new HashMap<File, File>();
        ArtifactCollection workspaceBundles = new ArtifactCollection();
        String stateLocation = System.getProperty(SYSPROP_STATELOCATION);
        if (stateLocation != null) {
            Properties properties = this.loadWorkspaceState(new File(stateLocation, FILE_WORKSPACESTATE));
            for (Object key : properties.keySet()) {
                String stringKey = (String)key;
                if (!stringKey.endsWith(SUFFIX_LOCATION)) continue;
                DefaultArtifactKey artifactKey = this.toArtifactKey(stringKey);
                File location = this.toLocation(properties.getProperty(stringKey));
                workspaceBundles.addArtifactFile((ArtifactKey)artifactKey, location, null);
                stringKey = this.toStringKey((ArtifactKey)artifactKey);
                String basedir = properties.getProperty(stringKey + SUFFIX_BASEDIR);
                if (basedir == null) continue;
                workspaceBasedirs.put(new File(basedir), location);
                String deventries = properties.getProperty(stringKey + SUFFIX_ENTRIES);
                if (deventries == null) continue;
                workspaceDeventries.put(location, deventries);
            }
            this.stateLocation = new File(stateLocation);
        }
        this.workspaceBundles = workspaceBundles;
        this.workspaceBasedirs = Collections.unmodifiableMap(workspaceBasedirs);
        this.workspaceDeventries = Collections.unmodifiableMap(workspaceDeventries);
    }

    private Properties loadWorkspaceState(File workspaceState) {
        Properties properties = new Properties();
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(workspaceState));){
            properties.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    private DefaultArtifactKey toArtifactKey(String key) {
        StringTokenizer st = new StringTokenizer(key, ":");
        String type = st.nextToken();
        String id = st.nextToken();
        String version = st.nextToken();
        return new DefaultArtifactKey(type, id, version);
    }

    private File toLocation(String location) {
        return new File(location);
    }

    private String toStringKey(ArtifactKey key) {
        StringBuilder sb = new StringBuilder();
        sb.append(key.getType());
        sb.append(':').append(key.getId()).append(':').append(key.getVersion());
        return sb.toString();
    }

    public DevBundleInfo getBundleInfo(String symbolicName, String version) {
        ArtifactDescriptor descriptor = this.workspaceBundles.getArtifact("eclipse-plugin", symbolicName, version);
        return this.newBundleInfo(descriptor);
    }

    private DevBundleInfo newBundleInfo(ArtifactDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        File location = descriptor.getLocation(true);
        return new DevBundleInfo(descriptor.getKey(), location, this.workspaceDeventries.get(location));
    }

    public DevBundleInfo getBundleInfo(File projectBasedir) {
        File location = this.workspaceBasedirs.get(projectBasedir);
        if (location != null) {
            ArtifactDescriptor descriptor = this.workspaceBundles.getArtifact(location).get(null);
            return this.newBundleInfo(descriptor);
        }
        return null;
    }

    public DevBundleInfo getBundleInfo(MavenSession session, String groupId, String artifacyId, String version, List<ArtifactRepository> repositories) {
        Artifact pomArtifact = this.repositorySystem.createArtifact(groupId, artifacyId, version, "pom");
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(pomArtifact);
        request.setResolveRoot(true).setResolveTransitively(false);
        request.setLocalRepository(session.getLocalRepository());
        request.setRemoteRepositories(repositories);
        request.setCache(session.getRepositoryCache());
        request.setOffline(session.isOffline());
        request.setForceUpdate(session.getRequest().isUpdateSnapshots());
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        if (result.isSuccess()) {
            return this.getBundleInfo(pomArtifact.getFile().getParentFile());
        }
        return null;
    }

    public File getStateLocation() {
        return this.stateLocation;
    }
}

