/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.ee;

import de.pdark.decentxml.Attribute;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.XMLIOSource;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.tycho.core.shared.MavenArtifactRepositoryReference;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionSyntaxException;

public final class TargetDefinitionFile
implements TargetDefinition {
    private static final XMLParser PARSER = new XMLParser();
    private static final Map<String, TargetDefinitionFile> FILE_CACHE = new ConcurrentHashMap<String, TargetDefinitionFile>();
    private final File origin;
    private final byte[] fileContentHash;
    private final Element dom;
    private final Document document;

    private static String getTextFromChild(Element dom, String childName, String defaultValue) {
        Iterator iterator = dom.getChildren(childName).iterator();
        if (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            return element.getNormalizedText();
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new TargetDefinitionSyntaxException("Missing child element '" + childName + "'");
    }

    private static String getKey(IArtifactFacade artifact) {
        if (artifact == null) {
            return "";
        }
        String key = artifact.getGroupId() + ":" + artifact.getArtifactId();
        String classifier = artifact.getClassifier();
        if (classifier != null && !classifier.isBlank()) {
            key = key + ":" + classifier;
        }
        key = key + ":" + artifact.getVersion();
        return key;
    }

    private TargetDefinitionFile(File source) throws TargetDefinitionSyntaxException {
        try {
            this.origin = source;
            this.fileContentHash = TargetDefinitionFile.computeFileContentHash(source);
            try (FileInputStream input = new FileInputStream(source);){
                this.document = PARSER.parse((XMLSource)new XMLIOSource(source));
                this.dom = this.document.getRootElement();
            }
        }
        catch (XMLParseException e) {
            throw new TargetDefinitionSyntaxException("Target definition is not well-formed XML: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new TargetDefinitionSyntaxException("I/O error while reading target definition file: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<? extends TargetDefinition.Location> getLocations() {
        ArrayList<Object> locations = new ArrayList<Object>();
        Element locationsDom = this.dom.getChild("locations");
        if (locationsDom != null) {
            for (Element locationDom : locationsDom.getChildren("location")) {
                String type = locationDom.getAttributeValue("type");
                if ("InstallableUnit".equals(type)) {
                    locations.add(new IULocation(locationDom));
                    continue;
                }
                if ("Directory".equals(type)) {
                    locations.add(new DirectoryTargetLocation(locationDom.getAttributeValue("path")));
                    continue;
                }
                if ("Profile".equals(type)) {
                    locations.add(new ProfileTargetPlatformLocation(locationDom.getAttributeValue("path")));
                    continue;
                }
                if ("Feature".equals(type)) {
                    locations.add(new FeatureTargetPlatformLocation(locationDom.getAttributeValue("path"), locationDom.getAttributeValue("id"), locationDom.getAttributeValue("version")));
                    continue;
                }
                if ("Maven".equals(type)) {
                    locations.add(new MavenLocation(locationDom));
                    continue;
                }
                locations.add(new OtherLocation(type));
            }
        }
        return Collections.unmodifiableList(locations);
    }

    public boolean hasIncludedBundles() {
        return this.dom.getChild("includeBundles") != null;
    }

    public String getOrigin() {
        return this.origin.getAbsolutePath();
    }

    public static TargetDefinitionFile read(File file) {
        try {
            return FILE_CACHE.computeIfAbsent(file.getAbsolutePath(), key -> new TargetDefinitionFile(file));
        }
        catch (TargetDefinitionSyntaxException e) {
            throw new RuntimeException("Invalid syntax in target definition " + file + ": " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(TargetDefinitionFile target, File file) throws IOException {
        Document document = target.document;
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            String enc = document.getEncoding() != null ? document.getEncoding() : "UTF-8";
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, enc);
            XMLWriter xw = new XMLWriter((Writer)w);
            try {
                document.toXML(xw);
            }
            finally {
                xw.flush();
            }
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.fileContentHash);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TargetDefinitionFile)) {
            return false;
        }
        TargetDefinitionFile other = (TargetDefinitionFile)obj;
        return Arrays.equals(this.fileContentHash, other.fileContentHash);
    }

    private static byte[] computeFileContentHash(File source) {
        byte[] digest;
        try {
            digest = TargetDefinitionFile.computeMD5Digest(source);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while reading \"" + source + "\": " + e.getMessage(), e);
        }
        return digest;
    }

    private static byte[] computeMD5Digest(File in) throws IOException {
        MessageDigest digest = TargetDefinitionFile.newMD5Digest();
        digest.update(Files.readAllBytes(in.toPath()));
        return digest.digest();
    }

    private static MessageDigest newMD5Digest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTargetEE() {
        Attribute path;
        Element targetJRE = this.dom.getChild("targetJRE");
        if (targetJRE != null && (path = targetJRE.getAttribute("path")) != null) {
            String pathValue = path.getValue();
            return pathValue.substring(pathValue.lastIndexOf(47) + 1);
        }
        return null;
    }

    public String toString() {
        return "TargetDefinitionFile[" + this.origin + "]";
    }

    public class IULocation
    implements TargetDefinition.InstallableUnitLocation {
        private final Element dom;

        public IULocation(Element dom) {
            this.dom = dom;
        }

        public List<? extends TargetDefinition.Unit> getUnits() {
            ArrayList<Unit> units = new ArrayList<Unit>();
            for (Element unitDom : this.dom.getChildren("unit")) {
                units.add(new Unit(unitDom));
            }
            return Collections.unmodifiableList(units);
        }

        public List<? extends TargetDefinition.Repository> getRepositories() {
            return this.getRepositoryImpls();
        }

        public List<Repository> getRepositoryImpls() {
            List repositoryNodes = this.dom.getChildren("repository");
            ArrayList<Repository> repositories = new ArrayList<Repository>(repositoryNodes.size());
            for (Element node : repositoryNodes) {
                repositories.add(new Repository(node));
            }
            return repositories;
        }

        public String getTypeDescription() {
            return this.dom.getAttributeValue("type");
        }

        public TargetDefinition.IncludeMode getIncludeMode() {
            String attributeValue = this.dom.getAttributeValue("includeMode");
            if ("slicer".equals(attributeValue)) {
                return TargetDefinition.IncludeMode.SLICER;
            }
            if ("planner".equals(attributeValue) || attributeValue == null) {
                return TargetDefinition.IncludeMode.PLANNER;
            }
            throw new TargetDefinitionSyntaxException("Invalid value for attribute 'includeMode': " + attributeValue);
        }

        public boolean includeAllEnvironments() {
            return Boolean.parseBoolean(this.dom.getAttributeValue("includeAllPlatforms"));
        }

        public boolean includeSource() {
            return Boolean.parseBoolean(this.dom.getAttributeValue("includeSource"));
        }
    }

    public class DirectoryTargetLocation
    extends AbstractPathLocation
    implements TargetDefinition.DirectoryLocation {
        public DirectoryTargetLocation(String path) {
            super(path);
        }

        public String getTypeDescription() {
            return "Directory";
        }
    }

    public class ProfileTargetPlatformLocation
    extends AbstractPathLocation
    implements TargetDefinition.ProfileLocation {
        public ProfileTargetPlatformLocation(String path) {
            super(path);
        }

        public String getTypeDescription() {
            return "Profile";
        }
    }

    public class FeatureTargetPlatformLocation
    extends AbstractPathLocation
    implements TargetDefinition.FeaturesLocation {
        private final String feature;
        private final String version;

        public FeatureTargetPlatformLocation(String path, String feature, String version) {
            super(path);
            this.feature = feature;
            this.version = version;
        }

        public String getTypeDescription() {
            return "Feature";
        }

        public String getId() {
            return this.feature;
        }

        public String getVersion() {
            return this.version;
        }
    }

    public class MavenLocation
    implements TargetDefinition.MavenGAVLocation {
        private Element dom;
        private Set<String> globalExcludes = new HashSet<String>();

        public MavenLocation(Element dom) {
            this.dom = dom;
            List children = dom.getChildren("exclude");
            for (Element element : children) {
                this.globalExcludes.add(element.getNormalizedText());
            }
        }

        public String getTypeDescription() {
            return "Maven";
        }

        public String getIncludeDependencyScope() {
            return this.dom.getAttributeValue("includeDependencyScope");
        }

        public TargetDefinition.MavenGAVLocation.MissingManifestStrategy getMissingManifestStrategy() {
            String attributeValue = this.dom.getAttributeValue("missingManifest");
            if ("generate".equalsIgnoreCase(attributeValue)) {
                return TargetDefinition.MavenGAVLocation.MissingManifestStrategy.GENERATE;
            }
            if ("ignore".equals(attributeValue)) {
                return TargetDefinition.MavenGAVLocation.MissingManifestStrategy.IGNORE;
            }
            return TargetDefinition.MavenGAVLocation.MissingManifestStrategy.ERROR;
        }

        public boolean includeSource() {
            return Boolean.parseBoolean(this.dom.getAttributeValue("includeSource"));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MavenDependencyRoots = ");
            builder.append(this.getRoots());
            builder.append(", IncludeDependencyScope = ");
            builder.append(this.getIncludeDependencyScope());
            builder.append(", MissingManifestStrategy = ");
            builder.append(this.getMissingManifestStrategy());
            builder.append(", IncludeSource = ");
            builder.append(this.includeSource());
            return builder.toString();
        }

        public Collection<TargetDefinition.BNDInstructions> getInstructions() {
            ArrayList<TargetDefinition.BNDInstructions> list = new ArrayList<TargetDefinition.BNDInstructions>();
            for (Element element : this.dom.getChildren("instructions")) {
                final String reference = element.getAttributeValue("reference");
                String text = element.getText();
                final Properties properties = new Properties();
                try {
                    properties.load(new StringReader(text));
                }
                catch (IOException e) {
                    throw new TargetDefinitionSyntaxException("parsing instructions into properties failed", (Throwable)e);
                }
                list.add(new TargetDefinition.BNDInstructions(){

                    public String getReference() {
                        if (reference == null) {
                            return "";
                        }
                        return reference;
                    }

                    public Properties getInstructions() {
                        return properties;
                    }
                });
            }
            return list;
        }

        public Collection<TargetDefinition.MavenDependency> getRoots() {
            Iterator iterator = this.dom.getChildren("dependencies").iterator();
            if (iterator.hasNext()) {
                Element dependencies = (Element)iterator.next();
                ArrayList<TargetDefinition.MavenDependency> roots = new ArrayList<TargetDefinition.MavenDependency>();
                for (Element dependency : dependencies.getChildren("dependency")) {
                    roots.add(new MavenDependencyRoot(dependency, this));
                }
                return roots;
            }
            return Collections.singleton(new MavenDependencyRoot(this.dom, this));
        }

        public Collection<MavenArtifactRepositoryReference> getRepositoryReferences() {
            Iterator iterator = this.dom.getChildren("repositories").iterator();
            if (iterator.hasNext()) {
                Element dependencies = (Element)iterator.next();
                ArrayList<MavenArtifactRepositoryReference> list = new ArrayList<MavenArtifactRepositoryReference>();
                for (final Element repository : dependencies.getChildren("repository")) {
                    list.add(new MavenArtifactRepositoryReference(){

                        public String getId() {
                            return TargetDefinitionFile.getTextFromChild(repository, "id", String.valueOf(System.identityHashCode(repository)));
                        }

                        public String getUrl() {
                            return TargetDefinitionFile.getTextFromChild(repository, "url", null);
                        }
                    });
                }
                return list;
            }
            return Collections.emptyList();
        }
    }

    public static class OtherLocation
    implements TargetDefinition.Location {
        private final String description;

        public OtherLocation(String description) {
            this.description = description;
        }

        public String getTypeDescription() {
            return this.description;
        }
    }

    public static class Unit
    implements TargetDefinition.Unit {
        private final Element dom;

        public Unit(Element dom) {
            this.dom = dom;
        }

        public String getId() {
            return this.dom.getAttributeValue("id");
        }

        public String getVersion() {
            return this.dom.getAttributeValue("version");
        }

        @Deprecated
        public void setVersion(String version) {
            this.dom.setAttribute("version", version);
        }
    }

    public static final class Repository
    implements TargetDefinition.Repository {
        private final Element dom;

        public Repository(Element dom) {
            this.dom = dom;
        }

        public String getId() {
            return this.dom.getAttributeValue("id");
        }

        public URI getLocation() {
            try {
                return new URI(this.dom.getAttributeValue("location"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        @Deprecated
        public void setLocation(String location) {
            this.dom.setAttribute("location", location);
        }
    }

    private static final class MavenDependencyRoot
    implements TargetDefinition.MavenDependency {
        private Element dom;
        private MavenLocation parent;

        public MavenDependencyRoot(Element dom, MavenLocation parent) {
            this.dom = dom;
            this.parent = parent;
        }

        public String getGroupId() {
            return TargetDefinitionFile.getTextFromChild(this.dom, "groupId", null);
        }

        public String getArtifactId() {
            return TargetDefinitionFile.getTextFromChild(this.dom, "artifactId", null);
        }

        public String getVersion() {
            return TargetDefinitionFile.getTextFromChild(this.dom, "version", null);
        }

        public String getArtifactType() {
            return TargetDefinitionFile.getTextFromChild(this.dom, "type", "jar");
        }

        public String getClassifier() {
            return TargetDefinitionFile.getTextFromChild(this.dom, "classifier", "");
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GroupId = ");
            builder.append(this.getGroupId());
            builder.append(", ArtifactId = ");
            builder.append(this.getArtifactId());
            builder.append(", Version = ");
            builder.append(this.getVersion());
            builder.append(", ArtifactType = ");
            builder.append(this.getArtifactType());
            builder.append(", IncludeDependencyScope = ");
            return builder.toString();
        }

        public boolean isIgnored(IArtifactFacade artifact) {
            return this.parent.globalExcludes.contains(TargetDefinitionFile.getKey(artifact));
        }
    }

    private abstract class AbstractPathLocation
    implements TargetDefinition.PathLocation {
        private String path;

        public AbstractPathLocation(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

