/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaModule;
import com.thoughtworks.qdox.model.JavaModuleDescriptor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;

public class QDoxModuleInfoParser {
    public JavaModuleDescriptor fromSourcePath(Path modulePath) throws IOException {
        JavaModuleDescriptor.Builder builder;
        File moduleDescriptor = modulePath.toFile();
        if (moduleDescriptor.exists()) {
            com.thoughtworks.qdox.model.JavaModuleDescriptor descriptor = new JavaProjectBuilder().addSourceFolder(moduleDescriptor.getParentFile()).getDescriptor();
            builder = JavaModuleDescriptor.newModule(descriptor.getName());
            for (JavaModuleDescriptor.JavaRequires requires : descriptor.getRequires()) {
                if (requires.isStatic()) {
                    builder.requires(Collections.singleton(JavaModuleDescriptor.JavaRequires.JavaModifier.STATIC), requires.getModule().getName());
                    continue;
                }
                builder.requires(requires.getModule().getName());
            }
            for (JavaModuleDescriptor.JavaExports exports : descriptor.getExports()) {
                if (exports.getTargets().isEmpty()) {
                    builder.exports(exports.getSource().getName());
                    continue;
                }
                LinkedHashSet<String> targets = new LinkedHashSet<String>();
                for (JavaModule module : exports.getTargets()) {
                    targets.add(module.getName());
                }
                builder.exports(exports.getSource().getName(), targets);
            }
        } else {
            builder = JavaModuleDescriptor.newAutomaticModule(null);
        }
        return builder.build();
    }
}

