/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging.sourceref;

import java.util.Map;
import java.util.jar.Manifest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tycho.packaging.SourceReferences;
import org.eclipse.tycho.packaging.sourceref.ScmUrl;
import org.eclipse.tycho.packaging.sourceref.SourceReferencesProvider;

@Component(role=SourceReferenceComputer.class)
public class SourceReferenceComputer {
    private static final String MANIFEST_HEADER = "Eclipse-SourceReferences";
    @Requirement
    private Map<String, SourceReferencesProvider> providerMap;

    public void addSourceReferenceHeader(Manifest manifest, SourceReferences sourceRefsConfiguration, MavenProject project) throws MojoExecutionException {
        if (!sourceRefsConfiguration.shouldGenerate()) {
            return;
        }
        if (sourceRefsConfiguration.getCustomValue() != null) {
            SourceReferenceComputer.addSourceReferencesHeader(manifest, sourceRefsConfiguration.getCustomValue());
            return;
        }
        ScmUrl scmUrl = new ScmUrl(project.getProperties());
        String providerHint = scmUrl.getType();
        SourceReferencesProvider provider = this.providerMap.get(providerHint);
        if (provider == null) {
            throw new MojoExecutionException("No source references provider for SCM type '" + providerHint + "' registered.");
        }
        SourceReferenceComputer.addSourceReferencesHeader(manifest, provider.getSourceReferencesHeader(project, scmUrl));
    }

    private static void addSourceReferencesHeader(Manifest manifest, String value) {
        manifest.getMainAttributes().putValue(MANIFEST_HEADER, value);
    }
}

