/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.equinox.launching.internal;

import java.io.File;
import java.io.IOException;
import org.eclipse.sisu.equinox.launching.EquinoxInstallation;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationDescription;
import org.eclipse.tycho.ArtifactDescriptor;
import org.osgi.framework.Version;

public class DefaultEquinoxInstallation
implements EquinoxInstallation {
    private final File location;
    private final File configurationLocation;
    private final EquinoxInstallationDescription description;

    public DefaultEquinoxInstallation(EquinoxInstallationDescription installationDescription, File location, File configurationLocation) {
        this.description = installationDescription;
        this.location = location;
        this.configurationLocation = configurationLocation;
    }

    @Override
    public File getLocation() {
        return this.location;
    }

    @Override
    public File getConfigurationLocation() {
        return this.configurationLocation;
    }

    @Override
    public File getLauncherJar() {
        ArtifactDescriptor systemBundle = this.description.getSystemBundle();
        Version osgiVersion = Version.parseVersion((String)systemBundle.getKey().getVersion());
        if (osgiVersion.compareTo(EquinoxInstallationDescription.EQUINOX_VERSION_3_3_0) < 0) {
            throw new IllegalArgumentException("Eclipse 3.2 and earlier are not supported.");
        }
        ArtifactDescriptor launcher = this.description.getBundle("org.eclipse.equinox.launcher", null);
        if (launcher == null) {
            throw new IllegalArgumentException("Could not find org.eclipse.equinox.launcher bundle in the test runtime.");
        }
        try {
            return launcher.getLocation(true).getCanonicalFile();
        }
        catch (IOException e) {
            return launcher.getLocation(true).getAbsoluteFile();
        }
    }

    @Override
    public EquinoxInstallationDescription getInstallationDescription() {
        return this.description;
    }
}

