/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.function.Consumer;
import org.openjdk.jmc.flightrecorder.writer.MetadataImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeStructureBuilderImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeStructureImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldBuilderImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.TypeStructure;
import org.openjdk.jmc.flightrecorder.writer.api.TypeStructureBuilder;
import org.openjdk.jmc.flightrecorder.writer.api.TypedFieldBuilder;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

public final class TypesImpl
extends Types {
    private final MetadataImpl metadata;

    TypesImpl(MetadataImpl metadata) {
        this(metadata, true);
    }

    TypesImpl(MetadataImpl metadata, boolean initialize) {
        metadata.setTypes(this);
        this.metadata = metadata;
        this.registerBuiltins();
        if (initialize) {
            this.registerJdkTypes();
            this.metadata.resolveTypes();
        }
    }

    private void registerBuiltins() {
        this.metadata.registerBuiltin(Types.Builtin.BYTE);
        this.metadata.registerBuiltin(Types.Builtin.CHAR);
        this.metadata.registerBuiltin(Types.Builtin.SHORT);
        this.metadata.registerBuiltin(Types.Builtin.INT);
        this.metadata.registerBuiltin(Types.Builtin.LONG);
        this.metadata.registerBuiltin(Types.Builtin.FLOAT);
        this.metadata.registerBuiltin(Types.Builtin.DOUBLE);
        this.metadata.registerBuiltin(Types.Builtin.BOOLEAN);
        this.metadata.registerBuiltin(Types.Builtin.STRING);
    }

    private void registerJdkTypes() {
        Type annotationNameType = this.getOrAdd((Types.Predefined)Types.JDK.ANNOTATION_NAME, "java.lang.annotation.Annotation", builder -> builder.addField("value", Types.Builtin.STRING));
        Type annotationLabelType = this.getOrAdd((Types.Predefined)Types.JDK.ANNOTATION_LABEL, "java.lang.annotation.Annotation", builder -> builder.addField("value", Types.Builtin.STRING));
        Type annotationDescriptionType = this.getOrAdd((Types.Predefined)Types.JDK.ANNOTATION_DESCRIPTION, "java.lang.annotation.Annotation", builder -> builder.addField("value", Types.Builtin.STRING));
        Type annotationContentTypeType = this.getOrAdd((Types.Predefined)Types.JDK.ANNOTATION_CONTENT_TYPE, "java.lang.annotation.Annotation", builder -> {});
        this.getOrAdd((Types.Predefined)Types.JDK.ANNOTATION_TIMESTAMP, "java.lang.annotation.Annotation", arg_0 -> TypesImpl.lambda$registerJdkTypes$4((TypeImpl)annotationNameType, (TypeImpl)annotationContentTypeType, (TypeImpl)annotationLabelType, (TypeImpl)annotationDescriptionType, arg_0));
        this.getOrAdd((Types.Predefined)Types.JDK.ANNOTATION_TIMESPAN, "java.lang.annotation.Annotation", arg_0 -> TypesImpl.lambda$registerJdkTypes$5((TypeImpl)annotationNameType, (TypeImpl)annotationContentTypeType, (TypeImpl)annotationLabelType, (TypeImpl)annotationDescriptionType, arg_0));
        this.getOrAdd((Types.Predefined)Types.JDK.ANNOTATION_UNSIGNED, "java.lang.annotation.Annotation", arg_0 -> TypesImpl.lambda$registerJdkTypes$6((TypeImpl)annotationNameType, (TypeImpl)annotationContentTypeType, (TypeImpl)annotationLabelType, (TypeImpl)annotationDescriptionType, arg_0));
        this.getOrAdd((Types.Predefined)Types.JDK.ANNOTATION_CATEGORY, "java.lang.annotation.Annotation", arg_0 -> TypesImpl.lambda$registerJdkTypes$7((TypeImpl)annotationNameType, arg_0));
        this.getOrAdd((Types.Predefined)Types.JDK.TICKSPAN, builder -> builder.addField("tickSpan", Types.Builtin.LONG));
        this.getOrAdd((Types.Predefined)Types.JDK.TICKS, builder -> builder.addField("ticks", Types.Builtin.LONG));
        Type threadGroupType = this.getOrAdd((Types.Predefined)Types.JDK.THREAD_GROUP, tgBuilder -> tgBuilder.addField("parent", tgBuilder.selfType()).addField("name", this.getType(Types.Builtin.STRING)));
        this.getOrAdd((Types.Predefined)Types.JDK.THREAD, arg_0 -> this.lambda$registerJdkTypes$11((TypeImpl)threadGroupType, arg_0));
        Type symbol = this.getOrAdd((Types.Predefined)Types.JDK.SYMBOL, builder -> builder.addField("string", Types.Builtin.STRING));
        Type classLoader = this.getOrAdd((Types.Predefined)Types.JDK.CLASS_LOADER, arg_0 -> TypesImpl.lambda$registerJdkTypes$13((TypeImpl)symbol, arg_0));
        Type moduleType = this.getOrAdd((Types.Predefined)Types.JDK.MODULE, arg_0 -> TypesImpl.lambda$registerJdkTypes$14((TypeImpl)symbol, (TypeImpl)classLoader, arg_0));
        Type packageType = this.getOrAdd((Types.Predefined)Types.JDK.PACKAGE, arg_0 -> TypesImpl.lambda$registerJdkTypes$15((TypeImpl)symbol, (TypeImpl)moduleType, arg_0));
        Type classType = this.getOrAdd((Types.Predefined)Types.JDK.CLASS, arg_0 -> TypesImpl.lambda$registerJdkTypes$16((TypeImpl)classLoader, (TypeImpl)symbol, (TypeImpl)packageType, arg_0));
        Type methodType = this.getOrAdd((Types.Predefined)Types.JDK.METHOD, arg_0 -> TypesImpl.lambda$registerJdkTypes$17((TypeImpl)classType, (TypeImpl)symbol, arg_0));
        this.getOrAdd((Types.Predefined)Types.JDK.FRAME_TYPE, builder -> builder.addField("description", Types.Builtin.STRING));
        this.getOrAdd((Types.Predefined)Types.JDK.STACK_FRAME, arg_0 -> TypesImpl.lambda$registerJdkTypes$19((TypeImpl)methodType, arg_0));
        this.getOrAdd((Types.Predefined)Types.JDK.STACK_TRACE, builder -> builder.addField("truncated", Types.Builtin.BOOLEAN).addField("frames", Types.JDK.STACK_FRAME, TypedFieldBuilder::asArray));
    }

    @Override
    public TypeImpl getOrAdd(Types.Predefined type, Consumer<TypeStructureBuilder> builderCallback) {
        return this.getOrAdd(type.getTypeName(), true, (Consumer)builderCallback);
    }

    @Override
    public TypeImpl getOrAdd(String name, boolean withConstantPool, Consumer<TypeStructureBuilder> builderCallback) {
        return this.getOrAdd(name, (String)null, withConstantPool, (Consumer)builderCallback);
    }

    @Override
    public TypeImpl getOrAdd(Types.Predefined type, String supertype, Consumer<TypeStructureBuilder> builderCallback) {
        return this.getOrAdd(type.getTypeName(), supertype, true, (Consumer)builderCallback);
    }

    @Override
    public TypeImpl getOrAdd(String name, String supertype, boolean withConstantPool, Consumer<TypeStructureBuilder> builderCallback) {
        return this.metadata.registerType(name, supertype, withConstantPool, () -> {
            TypeStructureBuilderImpl builder = new TypeStructureBuilderImpl(this);
            builderCallback.accept(builder);
            return (TypeStructureImpl)builder.build();
        });
    }

    @Override
    public TypeImpl getOrAdd(String name, String supertype, boolean withConstantPool, TypeStructure typeStructure) {
        return this.metadata.registerType(name, supertype, withConstantPool, (TypeStructureImpl)typeStructure);
    }

    @Override
    public TypeImpl getOrAdd(String name, Consumer<TypeStructureBuilder> builderCallback) {
        return this.getOrAdd(name, true, (Consumer)builderCallback);
    }

    @Override
    public TypeImpl getOrAdd(String name, String supertype, Consumer<TypeStructureBuilder> builderCallback) {
        return this.getOrAdd(name, supertype, true, (Consumer)builderCallback);
    }

    @Override
    public TypeImpl getOrAdd(String name, String supertype, TypeStructure typeStructure) {
        return this.getOrAdd(name, supertype, true, typeStructure);
    }

    @Override
    public TypeImpl getType(String name) {
        return this.getType(name, false);
    }

    @Override
    public TypeImpl getType(String name, boolean asResolvable) {
        return this.metadata.getType(name, asResolvable);
    }

    @Override
    public TypeImpl getType(Types.Predefined type) {
        return this.getType(type.getTypeName(), true);
    }

    @Override
    public TypeStructureBuilder typeStructureBuilder() {
        return new TypeStructureBuilderImpl(this);
    }

    @Override
    public TypedFieldBuilder fieldBuilder(String fieldName, Type fieldType) {
        return new TypedFieldBuilderImpl(fieldName, (TypeImpl)fieldType, this);
    }

    @Override
    public TypedFieldBuilder fieldBuilder(String fieldName, Types.Builtin fieldType) {
        return new TypedFieldBuilderImpl(fieldName, this.getType(fieldType), this);
    }

    public void resolveAll() {
        this.metadata.resolveTypes();
    }

    private static /* synthetic */ void lambda$registerJdkTypes$19(TypeImpl methodType, TypeStructureBuilder builder) {
        builder.addField("method", methodType).addField("lineNumber", Types.Builtin.INT).addField("bytecodeIndex", Types.Builtin.INT).addField("type", Types.JDK.FRAME_TYPE);
    }

    private static /* synthetic */ void lambda$registerJdkTypes$17(TypeImpl classType, TypeImpl symbol, TypeStructureBuilder builder) {
        builder.addField("type", classType).addField("name", symbol).addField("descriptor", symbol).addField("modifiers", Types.Builtin.INT).addField("hidden", Types.Builtin.BOOLEAN);
    }

    private static /* synthetic */ void lambda$registerJdkTypes$16(TypeImpl classLoader, TypeImpl symbol, TypeImpl packageType, TypeStructureBuilder builder) {
        builder.addField("classLoader", classLoader).addField("name", symbol).addField("package", packageType).addField("modifiers", Types.Builtin.INT).addField("hidden", Types.Builtin.BOOLEAN);
    }

    private static /* synthetic */ void lambda$registerJdkTypes$15(TypeImpl symbol, TypeImpl moduleType, TypeStructureBuilder builder) {
        builder.addField("name", symbol).addField("module", moduleType).addField("exported", Types.Builtin.BOOLEAN);
    }

    private static /* synthetic */ void lambda$registerJdkTypes$14(TypeImpl symbol, TypeImpl classLoader, TypeStructureBuilder builder) {
        builder.addField("name", symbol).addField("version", symbol).addField("location", symbol).addField("classLoader", classLoader);
    }

    private static /* synthetic */ void lambda$registerJdkTypes$13(TypeImpl symbol, TypeStructureBuilder builder) {
        builder.addField("type", Types.JDK.CLASS).addField("name", symbol);
    }

    private /* synthetic */ void lambda$registerJdkTypes$11(TypeImpl threadGroupType, TypeStructureBuilder typeBuilder) {
        typeBuilder.addField("osName", this.getType(Types.Builtin.STRING)).addField("osThreadId", this.getType(Types.Builtin.LONG)).addField("javaName", this.getType(Types.Builtin.STRING)).addField("group", threadGroupType);
    }

    private static /* synthetic */ void lambda$registerJdkTypes$7(TypeImpl annotationNameType, TypeStructureBuilder builder) {
        builder.addField("value", Types.Builtin.STRING, TypedFieldBuilder::asArray).addAnnotation((Type)annotationNameType, "jdk.jfr.Category");
    }

    private static /* synthetic */ void lambda$registerJdkTypes$6(TypeImpl annotationNameType, TypeImpl annotationContentTypeType, TypeImpl annotationLabelType, TypeImpl annotationDescriptionType, TypeStructureBuilder builder) {
        ((TypeStructureBuilder)((TypeStructureBuilder)((TypeStructureBuilder)builder.addField("value", Types.Builtin.STRING).addAnnotation((Type)annotationNameType, "jdk.jfr.Unsigned")).addAnnotation(annotationContentTypeType)).addAnnotation((Type)annotationLabelType, "Unsigned value")).addAnnotation((Type)annotationDescriptionType, "Value should be interpreted as unsigned data type");
    }

    private static /* synthetic */ void lambda$registerJdkTypes$5(TypeImpl annotationNameType, TypeImpl annotationContentTypeType, TypeImpl annotationLabelType, TypeImpl annotationDescriptionType, TypeStructureBuilder builder) {
        ((TypeStructureBuilder)((TypeStructureBuilder)((TypeStructureBuilder)builder.addField("value", Types.Builtin.STRING).addAnnotation((Type)annotationNameType, "jdk.jfr.Timespan")).addAnnotation(annotationContentTypeType)).addAnnotation((Type)annotationLabelType, "Timespan")).addAnnotation((Type)annotationDescriptionType, "A duration, measured in nanoseconds by default");
    }

    private static /* synthetic */ void lambda$registerJdkTypes$4(TypeImpl annotationNameType, TypeImpl annotationContentTypeType, TypeImpl annotationLabelType, TypeImpl annotationDescriptionType, TypeStructureBuilder builder) {
        ((TypeStructureBuilder)((TypeStructureBuilder)((TypeStructureBuilder)builder.addField("value", Types.Builtin.STRING).addAnnotation((Type)annotationNameType, "jdk.jfr.Timestamp")).addAnnotation(annotationContentTypeType)).addAnnotation((Type)annotationLabelType, "Timestamp")).addAnnotation((Type)annotationDescriptionType, "A point in time");
    }
}

