/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.Arrays;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.api.TypedFieldValue;
import org.openjdk.jmc.flightrecorder.writer.util.NonZeroHashCode;

public final class TypedFieldValueImpl
implements TypedFieldValue {
    private int hashCode = 0;
    private final TypedFieldImpl field;
    private final TypedValueImpl[] values;

    public TypedFieldValueImpl(TypedFieldImpl field, TypedValueImpl value) {
        this(field, new TypedValueImpl[]{value});
    }

    public TypedFieldValueImpl(TypedFieldImpl field, TypedValueImpl[] values) {
        if (values == null) {
            values = new TypedValueImpl[]{};
        }
        if (!field.isArray() && values.length > 1) {
            throw new IllegalArgumentException();
        }
        this.field = field;
        this.values = values;
    }

    @Override
    public TypedFieldImpl getField() {
        return this.field;
    }

    @Override
    public TypedValueImpl getValue() {
        if (this.field.isArray()) {
            throw new IllegalArgumentException();
        }
        return this.values[0];
    }

    public TypedValueImpl[] getValues() {
        if (!this.field.isArray()) {
            throw new IllegalArgumentException();
        }
        return Arrays.copyOf(this.values, this.values.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedFieldValueImpl that = (TypedFieldValueImpl)o;
        return this.field.equals(that.field) && Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            Object[] objValues = new Object[this.values.length + 1];
            System.arraycopy(this.values, 0, objValues, 1, this.values.length);
            objValues[0] = this.field;
            this.hashCode = NonZeroHashCode.hash(objValues);
        }
        return this.hashCode;
    }

    public String toString() {
        return "TypedFieldValueImpl{field=" + this.field + ", values=" + Arrays.toString(this.values) + '}';
    }
}

