/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openjdk.jmc.flightrecorder.writer.ImmutableMapEntry;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldValueImpl;
import org.openjdk.jmc.flightrecorder.writer.util.NonZeroHashCode;

final class SingleFieldMap
implements Map<String, TypedFieldValueImpl> {
    private int hashCode = 0;
    private final ImmutableMapEntry<String, TypedFieldValueImpl> entry;

    SingleFieldMap(String name, TypedFieldValueImpl value) {
        Objects.nonNull(name);
        Objects.nonNull(value);
        this.entry = new ImmutableMapEntry<String, TypedFieldValueImpl>(name, value);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object o) {
        return this.entry.getKey().equals(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.entry.getValue().equals(o);
    }

    @Override
    public TypedFieldValueImpl get(Object o) {
        return this.entry.getKey().equals(o) ? this.entry.getValue() : null;
    }

    @Override
    public TypedFieldValueImpl put(String s, TypedFieldValueImpl typedFieldValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypedFieldValueImpl remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends TypedFieldValueImpl> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        return Collections.singleton(this.entry.getKey());
    }

    @Override
    public Collection<TypedFieldValueImpl> values() {
        return Collections.singleton(this.entry.getValue());
    }

    @Override
    public Set<Map.Entry<String, TypedFieldValueImpl>> entrySet() {
        return Collections.singleton(this.entry);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleFieldMap that = (SingleFieldMap)o;
        return this.entry.equals(that.entry);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = NonZeroHashCode.hash(this.entry);
        }
        return this.hashCode;
    }

    public String toString() {
        return "SingleFieldMap{" + this.entry.getKey() + "=" + this.entry.getValue() + '}';
    }
}

