/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Consumer;
import org.openjdk.jmc.flightrecorder.writer.AbstractLEB128Writer;

final class LEB128ByteArrayWriter
extends AbstractLEB128Writer {
    private byte[] array;
    private int pointer = 0;

    LEB128ByteArrayWriter(int intialCapacity) {
        this.array = new byte[intialCapacity];
    }

    @Override
    public void reset() {
        Arrays.fill(this.array, (byte)0);
        this.pointer = 0;
    }

    @Override
    public long writeFloat(long offset, float data) {
        return this.writeIntRaw(offset, Float.floatToIntBits(data));
    }

    @Override
    public long writeDouble(long offset, double data) {
        return this.writeLongRaw(offset, Double.doubleToLongBits(data));
    }

    @Override
    public long writeByte(long offset, byte data) {
        int newOffset = (int)(offset + 1L);
        if (newOffset >= this.array.length) {
            this.array = Arrays.copyOf(this.array, newOffset * 2);
        }
        this.array[(int)offset] = data;
        this.pointer = Math.max(newOffset, this.pointer);
        return newOffset;
    }

    @Override
    public long writeBytes(long offset, byte ... data) {
        if (data == null) {
            return offset;
        }
        int newOffset = (int)(offset + (long)data.length);
        if (newOffset >= this.array.length) {
            this.array = Arrays.copyOf(this.array, newOffset * 2);
        }
        System.arraycopy(data, 0, this.array, (int)offset, data.length);
        this.pointer = Math.max(newOffset, this.pointer);
        return newOffset;
    }

    @Override
    public long writeShortRaw(long offset, short data) {
        return this.writeBytes(offset, (byte)(data >> 8 & 0xFF), (byte)(data & 0xFF));
    }

    @Override
    public long writeIntRaw(long offset, int data) {
        return this.writeBytes(offset, (byte)(data >> 24 & 0xFF), (byte)(data >> 16 & 0xFF), (byte)(data >> 8 & 0xFF), (byte)(data & 0xFF));
    }

    @Override
    public long writeLongRaw(long offset, long data) {
        return this.writeBytes(offset, (byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data & 0xFFL));
    }

    @Override
    public void export(Consumer<ByteBuffer> consumer) {
        ByteBuffer bb = ByteBuffer.wrap(this.array, 0, this.pointer);
        bb.position(this.pointer);
        consumer.accept(bb);
    }

    @Override
    public int position() {
        return this.pointer;
    }

    @Override
    public int capacity() {
        return this.array.length;
    }
}

