/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.Collections;
import java.util.List;
import org.openjdk.jmc.flightrecorder.writer.BaseType;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Annotation;
import org.openjdk.jmc.flightrecorder.writer.api.Types;
import org.openjdk.jmc.flightrecorder.writer.util.NonZeroHashCode;

final class BuiltinType
extends BaseType {
    private int hashcode = 0;
    private final Types.Builtin builtin;

    BuiltinType(long id, Types.Builtin type, ConstantPools constantPools, TypesImpl types) {
        super(id, type.getTypeName(), constantPools, types);
        this.builtin = type;
    }

    @Override
    public boolean isBuiltin() {
        return true;
    }

    @Override
    public List<TypedFieldImpl> getFields() {
        return Collections.emptyList();
    }

    @Override
    public TypedFieldImpl getField(String name) {
        throw new IllegalArgumentException();
    }

    @Override
    public List<Annotation> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public boolean canAccept(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof TypedValueImpl) {
            return this == ((TypedValueImpl)value).getType();
        }
        switch (this.builtin) {
            case STRING: {
                return value instanceof String;
            }
            case BYTE: {
                return value instanceof Byte;
            }
            case CHAR: {
                return value instanceof Character;
            }
            case SHORT: {
                return value instanceof Short;
            }
            case INT: {
                return value instanceof Integer;
            }
            case LONG: {
                return value instanceof Long;
            }
            case FLOAT: {
                return value instanceof Float;
            }
            case DOUBLE: {
                return value instanceof Double;
            }
            case BOOLEAN: {
                return value instanceof Boolean;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuiltinType that = (BuiltinType)o;
        return this.builtin == that.builtin;
    }

    @Override
    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = NonZeroHashCode.hash(super.hashCode(), this.builtin);
        }
        return this.hashcode;
    }

    @Override
    public String toString() {
        return "BuiltinType [builtin=" + this.builtin + "]";
    }
}

