/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.image.pixel;

import org.jemmy.image.pixel.AverageDistanceComparator;
import org.jemmy.image.pixel.Raster;
import org.jemmy.image.pixel.RasterComparator;

public class PeakSignalNoiseRatioComparator
implements RasterComparator {
    public static final String OUTPUT = PeakSignalNoiseRatioComparator.class.getName() + ".OUTPUT";
    private static final double MAX_CHANNEL = 1.0;
    private final double minRatio;

    private static double getMeanSquareError(Raster image, Raster original) {
        double result = 0.0;
        double[] colors1 = new double[image.getSupported().length];
        double[] colors2 = new double[original.getSupported().length];
        int w = Math.min(image.getSize().width, original.getSize().width);
        int h = Math.min(image.getSize().height, original.getSize().height);
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                image.getColors(i, j, colors1);
                original.getColors(i, j, colors2);
                double distance = AverageDistanceComparator.distance(image.getSupported(), colors1, original.getSupported(), colors2);
                result += distance * distance / (double)(AverageDistanceComparator.DISTANCE_COMPONENTS.length * w * h);
            }
        }
        return result;
    }

    private static double getPeakSignalNoiseRatio(Raster image, Raster original) {
        double mse = PeakSignalNoiseRatioComparator.getMeanSquareError(image, original);
        return 20.0 * Math.log10(1.0) - 10.0 * Math.log10(mse);
    }

    public PeakSignalNoiseRatioComparator(double minRatio) {
        this.minRatio = minRatio;
    }

    @Override
    public boolean compare(Raster image1, Raster image2) {
        return PeakSignalNoiseRatioComparator.getPeakSignalNoiseRatio(image1, image2) > this.minRatio;
    }

    @Override
    public String getID() {
        return this.getClass().getName() + ":" + this.minRatio;
    }
}

