/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.project.BuildOutputJar;
import org.eclipse.tycho.core.osgitools.project.EclipsePluginProject;
import org.eclipse.tycho.core.shared.BuildProperties;
import org.eclipse.tycho.packaging.AbstractTychoPackagingMojo;
import org.eclipse.tycho.packaging.SourceReferences;
import org.eclipse.tycho.packaging.sourceref.SourceReferenceComputer;

@Mojo(name="package-plugin", threadSafe=true)
public class PackagePluginMojo
extends AbstractTychoPackagingMojo {
    @Parameter(property="project.build.directory", required=true)
    protected File buildDirectory;
    protected EclipsePluginProject pdeProject;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter
    private DefaultFileSet[] additionalFileSets;
    @Parameter(property="project.build.finalName", alias="jarName", required=true)
    protected String finalName;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter
    private SourceReferences sourceReferences = new SourceReferences();
    @Parameter(defaultValue="true")
    private boolean deriveHeaderFromProject = true;
    @Component
    private SourceReferenceComputer soureReferenceComputer;
    @Requirement
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
        this.pdeProject = (EclipsePluginProject)reactorProject.getContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_PROJECT);
        this.createSubJars();
        File pluginFile = this.createPluginJar();
        this.project.getArtifact().setFile(pluginFile);
    }

    private void createSubJars() throws MojoExecutionException {
        for (BuildOutputJar jar : this.pdeProject.getOutputJars()) {
            if (jar.isDirClasspathEntry()) continue;
            this.makeJar(jar);
        }
    }

    private File makeJar(BuildOutputJar jar) throws MojoExecutionException {
        String jarName = jar.getName();
        BuildProperties buildProperties = this.pdeProject.getBuildProperties();
        String customManifest = (String)buildProperties.getJarToManifestMap().get(jarName);
        try {
            File jarFile = new File(this.project.getBasedir(), jarName);
            JarArchiver archiver = new JarArchiver();
            archiver.setDestFile(jarFile);
            archiver.addDirectory(jar.getOutputDirectory());
            if (customManifest != null) {
                for (File sourceFolder : jar.getSourceFolders()) {
                    File manifestFile = new File(sourceFolder, customManifest);
                    if (!manifestFile.isFile()) continue;
                    archiver.setManifest(manifestFile);
                    break;
                }
            }
            archiver.createArchive();
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not create jar " + jarName, e);
        }
    }

    private File createPluginJar() throws MojoExecutionException {
        try {
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            File pluginFile = new File(this.buildDirectory, this.finalName + ".jar");
            if (pluginFile.exists()) {
                pluginFile.delete();
            }
            BuildProperties buildProperties = this.pdeProject.getBuildProperties();
            List binIncludesList = buildProperties.getBinIncludes();
            List binExcludesList = buildProperties.getBinExcludes();
            if (this.additionalFileSets != null) {
                for (DefaultFileSet fileSet : this.additionalFileSets) {
                    if (fileSet.getDirectory() == null || !fileSet.getDirectory().isDirectory()) continue;
                    archiver.getArchiver().addFileSet((FileSet)fileSet);
                }
            }
            ArrayList<String> binIncludesIgnoredForValidation = new ArrayList<String>();
            for (BuildOutputJar outputJar : this.pdeProject.getOutputJarMap().values()) {
                String jarName = outputJar.getName();
                if (!binIncludesList.contains(jarName) || !outputJar.isDirClasspathEntry()) continue;
                binIncludesIgnoredForValidation.add(jarName);
                String prefix = ".".equals(jarName) ? "" : jarName;
                archiver.getArchiver().addDirectory(outputJar.getOutputDirectory(), prefix);
            }
            this.checkBinIncludesExist(buildProperties, binIncludesIgnoredForValidation.toArray(new String[0]));
            archiver.getArchiver().addFileSet(this.getFileSet(this.project.getBasedir(), binIncludesList, binExcludesList));
            File manifest = new File(this.project.getBuild().getDirectory(), "MANIFEST.MF");
            this.updateManifest(manifest);
            this.archive.setManifestFile(manifest);
            archiver.setOutputFile(pluginFile);
            if (!this.archive.isForced()) {
                this.getLog().warn((CharSequence)"ignoring unsupported archive forced = false parameter.");
                this.archive.setForced(true);
            }
            archiver.createArchive(this.session, this.project, this.archive);
            return pluginFile;
        }
        catch (IOException | DependencyResolutionRequiredException | ArchiverException | ManifestException e) {
            throw new MojoExecutionException("Error assembling JAR", (Exception)e);
        }
    }

    private void updateManifest(File output) throws IOException, MojoExecutionException {
        this.writeManifest(output, this.getManifest());
    }

    protected void writeManifest(File output, Manifest mf) throws IOException {
        File parentFile = output.getParentFile();
        if (!parentFile.mkdirs() && !parentFile.exists()) {
            throw new IOException("creating target directory " + parentFile.getAbsolutePath() + " failed");
        }
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(output));){
            mf.write(os);
        }
    }

    protected Manifest getManifest() throws IOException, MojoExecutionException {
        Manifest mf;
        try (FileInputStream is = new FileInputStream(new File(this.project.getBasedir(), "META-INF/MANIFEST.MF"));){
            mf = new Manifest(is);
        }
        Attributes attributes = mf.getMainAttributes();
        if (attributes.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
        attributes.putValue("Bundle-Version", reactorProject.getExpandedVersion());
        this.soureReferenceComputer.addSourceReferenceHeader(mf, this.sourceReferences, this.project);
        if (this.deriveHeaderFromProject) {
            PackagePluginMojo.computeIfHeaderNotPresent(attributes, "Bundle-License", () -> {
                List licenses = this.project.getLicenses();
                return licenses.stream().map(license -> {
                    String name = license.getName();
                    if (name != null && !name.isBlank()) {
                        StringBuilder licenseHeader = new StringBuilder(name);
                        PackagePluginMojo.appendHeaderAttribute(licenseHeader, "link", license.getUrl());
                        return licenseHeader;
                    }
                    return null;
                }).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(","));
            });
        }
        return mf;
    }

    private static void appendHeaderAttribute(StringBuilder header, String attribute, String value) {
        if (value != null && !value.isBlank()) {
            header.append(";");
            header.append(attribute);
            header.append("=\"");
            header.append(value);
            header.append("\"");
        }
    }

    private static void computeIfHeaderNotPresent(Attributes attributes, String hv, Supplier<String> headerComputer) {
        String header;
        if (attributes.getValue(hv) == null && (header = headerComputer.get()) != null && !header.isBlank()) {
            attributes.putValue(hv, header);
        }
    }
}

