/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class TlabAllocationRatioRule
implements IRule {
    private static final String RESULT_ID = "TlabAllocationRatio";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.ObjectAllocationInNewTLAB", RulesToolkit.EventAvailability.ENABLED).addEventType("jdk.ObjectAllocationOutsideTLAB", RulesToolkit.EventAvailability.ENABLED).build();
    public static final TypedResult<IQuantity> OUTSIDE_TLAB_RATIO = new TypedResult("outsideTlabRatio", "Allocation Outside TLAB Ratio", "The percentage of all allocations occurring outside TLABs.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, OUTSIDE_TLAB_RATIO);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        IQuantity insideSum = (IQuantity)items.getAggregate(JdkAggregators.ALLOC_INSIDE_TLAB_SUM);
        IQuantity outsideSum = (IQuantity)items.getAggregate(JdkAggregators.ALLOC_OUTSIDE_TLAB_SUM);
        if (outsideSum == null) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("TlabAllocationRatioRuleFactory_TEXT_OK_NO_OUTSIDE")).build();
        }
        if (insideSum == null) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.WARNING).setSummary(Messages.getString("TlabAllocationRatioRuleFactory_TEXT_INFO_ONLY_OUTSIDE")).setExplanation(Messages.getString("TlabAllocationRatioRuleFactory_TEXT_INFO_ONLY_OUTSIDE_LONG")).setSolution(Messages.getString("TlabAllocationRatioRuleFactory_TEXT_RECOMMEND_LESS_ALLOCATION")).build();
        }
        IQuantity totalSum = insideSum.add(outsideSum);
        double rawRatio = outsideSum.ratioTo(totalSum);
        double score = RulesToolkit.mapExp74((double)rawRatio, (double)0.2);
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("TlabAllocationRatioRuleFactory_TEXT_INFO")).setSolution(Messages.getString("TlabAllocationRatioRuleFactory_TEXT_RECOMMEND_LESS_ALLOCATION")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(OUTSIDE_TLAB_RATIO, (Object)UnitLookup.PERCENT_UNITY.quantity(rawRatio)).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return TlabAllocationRatioRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("TlabAllocationRatioRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "tlab";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

