/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Serializable;
import java.util.Vector;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.WrappedRuntimeException;

public class ObjectPool
implements Serializable {
    private final Class objectType;
    private final Vector freeStack;

    public ObjectPool(Class type) {
        this.objectType = type;
        this.freeStack = new Vector();
    }

    public ObjectPool(String className) {
        try {
            this.objectType = Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new WrappedRuntimeException(cnfe);
        }
        this.freeStack = new Vector();
    }

    public ObjectPool(Class type, int size) {
        this.objectType = type;
        this.freeStack = new Vector(size);
    }

    public ObjectPool() {
        this.objectType = null;
        this.freeStack = new Vector();
    }

    public synchronized Object getInstanceIfFree() {
        if (!this.freeStack.isEmpty()) {
            Object result = this.freeStack.lastElement();
            this.freeStack.setSize(this.freeStack.size() - 1);
            return result;
        }
        return null;
    }

    public synchronized Object getInstance() {
        if (this.freeStack.isEmpty()) {
            try {
                return this.objectType.newInstance();
            }
            catch (InstantiationException ex) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            throw new RuntimeException(XMLMessages.createXMLMessage("ER_EXCEPTION_CREATING_POOL", null));
        }
        Object result = this.freeStack.lastElement();
        this.freeStack.setSize(this.freeStack.size() - 1);
        return result;
    }

    public synchronized void freeInstance(Object obj) {
        this.freeStack.addElement(obj);
    }
}

