/*
 * Copyright (c) 1997, 2022 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package com.sun.xml.xsom;

import java.math.*;

/**
 * Particle schema component.
 * 
 * @author
 *  Kohsuke Kawaguchi (kohsuke.kawaguchi@sun.com)
 */
public interface XSParticle extends XSContentType
{
    BigInteger getMinOccurs();
    /**
     * Gets the max occurs property.
     * 
     * @return
     *      {@link #UNBOUNDED} will be returned if the value
     *      is "unbounded".
     */
    BigInteger getMaxOccurs();

    /**
     * True if the maxOccurs is neither 0 or 1.
     */
    boolean isRepeated();

    int UNBOUNDED = -1;

    XSTerm getTerm();
}
